<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib prefix="s" uri="/struts-tags" %>
<!DOCTYPE html>
<html>
<head>
    <link rel="stylesheet" href="css/style.css"/>
    <link rel="stylesheet" href="css/bootstrap/bootstrap5-0-2.min.css"/>
    <link rel="stylesheet" href="css/admin_style.css">
    <link rel="shortcut icon" href="images/favicon.png">
    <title>Add LDAP Configuration</title>
</head>
<body class="white">
<jsp:include page="header.jsp"/>
<script src="${pageContext.request.contextPath}/js/select2.min.js"></script>
<link href='${pageContext.request.contextPath}/css/select2.min.css' rel='stylesheet' type='text/css'>
<div class="row me-0">
    <div class="col-md-2">
        <s:include value="menu.jsp">
            <s:param name="currentmenu" value="2"/>
        </s:include>
    </div>
    <div class="col-md-10 mt-4">
     <div class="container-fluid" id="actionMessages">
                <s:include value="actionmessages.jsp"/>
        </div>
        <div class="container-fluid">
            <div class="card ldap-panel shadow mb-4">
                <div class="card-header">
                    <h4 class="h4 mt-2">Add LDAP Connection
                        <a href="https://www.miniorange.com/miniorange-ldap-gateway#step6" target="_blank">
                            <i class="fas fa-external-link-alt note-color mt-0 pt-0"></i>
                        </a>
                    </h4>
                </div>
                <div class="card-body">
                     <div class="alert alert-primary" role="alert">
                        <i class="fa fa-info-circle"></i>&nbsp; Add a connection to Directory like Active Directory, OpenLDAP, Azure AD, Free IPA.
                    </div>
                    <s:form id="saveldapconfig" action="saveldapconfig" method="post">
                        <s:hidden name="ldapbinduserstoreoperation" id="ldapbinduserstoreoperation" value=""></s:hidden>
                        <jsp:include page="ldapconfiguration.jsp"/>
                    </s:form>
                </div>
            </div>
        </div>
    </div>
    <!--/div -->
    <jsp:include page="footer.jsp"/>
</body>
<script>
  $( document ).ready(function() {
    $("#ldapbinduserstoreoperation").val("saveldapconfig");

 });
</script>
</html>