<%@ taglib prefix="s" uri="/struts-tags"%>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate"/>
    <meta http-equiv="Pragma" content="no-cache"/>
    <meta http-equiv="Expires" content="0"/>
    <link rel="shortcut icon" href="images/favicon.png">
    <title>IDP URL Settings</title>
    <link rel="stylesheet" href="css/style.css"/>
    <link rel="stylesheet" href="css/admin_style.css">
    <link rel="stylesheet" href="css/bootstrap/bootstrap5-0-2.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link rel="stylesheet" href="css/advancesettings.css"/>
    <script src="js/jquery-3.5.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js"></script>
    <script src="js/advancesettings.js"></script>
</head>
<body class="white">
<jsp:include page="header.jsp" />
<div class="row me-0">
    <div class="col-md-2">
        <s:include value="menu.jsp">
            <s:param name="currentmenu" value="0" />
        </s:include>
    </div>
    <div class="col-md-10 mt-4">



        <div class="container-fluid">

        <!-- Action Messages -->
            <div class="container-fluid" id="actionMessages">
                <s:if test="hasActionMessages()">
                    <div class="alert alert-success alert-dismissible fade show d-flex align-items-center" role="alert">
                        <i class="fas fa-check-circle me-2"></i>
                        <div>
                            <s:actionmessage/>
                        </div>
                        <button type="button" class="btn-close ms-auto" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                </s:if>

                <s:if test="hasActionErrors()">
                    <div class="alert alert-danger alert-dismissible fade show d-flex align-items-center" role="alert">
                        <i class="fas fa-exclamation-circle me-2"></i>
                        <div>
                            <s:actionerror/>
                        </div>
                        <button type="button" class="btn-close ms-auto" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                </s:if>
            </div>


            <div class="card ldap-panel shadow">
                <div class="card-header">
                    <!-- Tabs -->
                    <ul class="nav nav-tabs" id="logSettingsTabs" role="tablist" style="margin-bottom:1rem;">
                        <li class="nav-item" role="presentation">
                            <button class="nav-link active" id="log-config-tab" data-bs-toggle="tab" data-bs-target="#log-config" type="button" role="tab">
                                General
                            </button>
                        </li>
                        <li class="nav-item" role="presentation" style="padding-left:25px">
                            <button class="nav-link" id="log-level-tab" data-bs-toggle="tab" data-bs-target="#log-level" type="button" role="tab">
                                Log Level
                            </button>
                        </li>
                    </ul>
                </div>

                <div class="card-body tab-content" id="logSettingsTabContent">
                    <!-- General Log Settings Tab -->
                    <div class="tab-pane fade show active" id="log-config" role="tabpanel" aria-labelledby="log-config-tab">
                        <div class="alert alert-primary d-flex fade show info-left" role="alert">
                            <p class="h6 p-1 mt-2">
                              &emsp;<i class="fa fa-info-circle"></i>
                              Configure logging with an absolute path (e.g.
                              <code>/var/log/</code> for Linux or
                              <code>C:\logs\</code> for Windows).
                              Restart the Gateway to apply changes.
                            </p>
                        </div>

                        <s:form id="logSettingsForm" action="save-log-settings" method="post" cssClass="login-group test-config">
                            <h5 class="h5 mt-2">Log configuration:</h5><br/>

                            <!-- Log Path -->
                            <div class="row">
                                <div class="col-md-3">
                                    <p class="input_field_fonts">Log Path:
                                        <a data-bs-toggle="tooltip"
                                           title="Specify the absolute folder path where application logs will be stored.&#10;(e.g., /var/log/ for Linux or C:\logs\ for Windows) ;Make sure the path is writable by the application.">
                                            <i class="fas fa-info-circle"></i>
                                        </a>
                                    </p>
                                </div>
                                <div class="col-md-6">
                                    <s:textfield name="rotatedLogPath" id="rotatedLogPath" cssClass="form-control"
                                                 placeholder="/path/to/logs" required="true"/>
                                </div>
                            </div>

                            <br>

                            <!-- Enable Retention -->
                            <div class="row">
                                <div class="col-md-3">
                                    <p class="input_field_fonts">Enable Log Retention:
                                        <a data-bs-toggle="tooltip"
                                           title="Turn this ON to automatically delete old log files after the retention period.">
                                            <i class="fas fa-info-circle"></i>
                                        </a>
                                    </p>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-check form-switch">
                                        <s:checkbox
                                                name="enableLogRetention"
                                                id="enableLogRetention"
                                                cssClass="form-check-input"
                                                fieldValue="true"
                                                role="switch"
                                                pattern="^[1-9][0-9]*$"
                                                aria-checked="%{enableLogRetention ? 'true' : 'false'}"
                                        />

                                    </div>
                                </div>
                            </div>

                            <br>

                            <!-- Retention Period -->
                            <div class="row" id="retentionDaysRow">
                                <div class="col-md-3">
                                    <p class="input_field_fonts">Retention Period (days):
                                        <a data-bs-toggle="tooltip"
                                           title="Number of days to retain log files before they are automatically deleted.">
                                            <i class="fas fa-info-circle"></i>
                                        </a>
                                    </p>
                                </div>
                                <div class="col-md-3">
                                     <s:textfield name="logRetentionPeriod"
                                                         id="logRetentionPeriod"
                                                         cssClass="form-control"
                                                         type="number"
                                                         min="1"
                                                         placeholder="30"
                                                         required="true"
                                                         pattern="^[1-9][0-9]*$"
                                                         title="Enter a valid number greater than or equal to 1"/>
                                </div>
                            </div>

                            <br>

                            <div class="row">
                                <div class="col-md-6 col-md-offset-3">
                                    <input type="submit" value="Save"
                                           class="btn btn-primary orange-btn"/>
                                </div>
                            </div>
                        </s:form>
                    </div>

                    <!-- Log Level Settings Tab -->
                    <div class="tab-pane fade" id="log-level" role="tabpanel" aria-labelledby="log-level-tab">
                        <div class="alert alert-primary d-flex fade show info-left" role="alert">
                            <p class="h6 p-1 mt-2">&emsp;<i class="fa fa-info-circle"></i>
                                Change the global log level for your application. Select the level and apply, no gateway restart required.
                            </p>
                        </div>


                        <s:form action="changeloglevel" method="POST" cssClass="mt-3">
                            <div class="loglevel profile-field row m-3 p-3 align-items-center bg-white rounded" id="logLevelSelector">
                                <div class="col-md-3">
                                    <h6 class="h6 pt-1 mb-0">Log Level:</h6>
                                </div>
                                <div class="col-md-6 d-flex align-items-center">
                                    <s:select name="currentLogLevel"
                                              list="allowedLogLevels"
                                              listKey="key"
                                              listValue="value"
                                              value="%{currentLogLevel}"
                                              headerKey=""
                                              headerValue="Select Log Level"
                                              cssClass="form-select shadow-sm"
                                              cssStyle="font-size: 0.95rem; padding: 0.4rem 0.75rem; border-radius: 0.375rem;" />

                                    <button type="submit" class="btn btn-sm ms-3 shadow-sm px-3"
                                            style="background-color: #EB6646; border: none; color:white;padding:8px">
                                        Change
                                    </button>
                                </div>
                            </div>
                        </s:form>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<jsp:include page="footer.jsp" />
</body>
</html>
