<%@ taglib prefix="s" uri="/struts-tags" %>
<%@ page contentType="text/html;charset=UTF-8" language="java" %>

<div class="ldap-history-container">
    <div class="history-card">
        <div class="card-header">
            <h4 class="h4">
                <i class="bi bi-gear me-2"></i>
                <s:if test="forLdapIdentifier != null && !forLdapIdentifier.isEmpty()">
                    <s:set var="cleanIdentifier" value="%{forLdapIdentifier.split(':+')[0]}"/>
                    <s:property value="#cleanIdentifier"/>
                    <s:if test="forLdapIdentifier.contains('DELETED')">
                        <span class="deleted-tag">(Deleted)</span>
                    </s:if>
                    change history
                </s:if>
                <s:else>
                    LDAP Configuration History
                </s:else>
            </h4>
            <s:if test="forLdapIdentifier != null && !forLdapIdentifier.isEmpty()">
                <div class="text-muted small">
                    Configuration change tracking for this LDAP identifier
                </div>
            </s:if>
        </div>
        <div class="card-body">
            <s:if test="changeSummariesForIdentifier != null && !changeSummariesForIdentifier.isEmpty()">
                <table class="history-table">
                     <colgroup>
                        <col style="width: 25%;">
                        <col style="width: 25%;">
                        <col style="width: 25%;">
                        <col style="width: 10%;">
                     </colgroup>
                    <thead>
                        <tr>
                            <th>
                                Last modified at
                                <button class="btn btn-sm btn-link sort-btn" onclick="sortTableByDate()">
                                    <i id="sortIcon" class="bi bi-arrow-down-up"></i>
                                </button>
                            </th>
                            <th>Actor</th>
                            <th>Summary</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <s:iterator value="changeSummariesForIdentifier" status="stat">
                            <tr>
                                <td class="saved-at">
                                    <s:date name="savedAt" format="yyyy-MM-dd HH:mm:ss"/>
                                </td>
                                <td>
                                    <s:property value="actor"/>
                                </td>
                                <td>
                                    <div class="summary-badge">
                                        <s:property value="changes.size()"/> fields changed
                                    </div>
                                </td>
                                <td>
                                    <div class="action-buttons">
                                        <button class="btn-view" onclick="openViewModal('<s:property value="#stat.index"/>')" title="View">
                                            <i class="bi bi-eye"></i>
                                        </button>
                                    </div>


                                    <!-- Hidden div to store change data for modal -->
                                    <div id="changeData-<s:property value="#stat.index"/>" style="display: none;">
                                        <s:if test="changes != null && !changes.isEmpty()">
                                            <%-- First, handle the combined User Profile Fields if both exist --%>
                                            <s:set var="hasFieldNames" value="changes.containsKey('idpUserProfileFieldNames')"/>
                                            <s:set var="hasFieldValues" value="changes.containsKey('idpUserProfileFieldValues')"/>

                                            <s:if test="#hasFieldNames && #hasFieldValues">
                                                <%-- Display combined User Profile Fields --%>
                                                <div class="change-group">
                                                    <div class="field-name">User Profile Field Mappings</div>
                                                    <s:set var="namesChange" value="changes.get('idpUserProfileFieldNames')"/>
                                                    <s:set var="valuesChange" value="changes.get('idpUserProfileFieldValues')"/>

                                                    <%-- Previous mapping --%>
                                                    <s:if test="#namesChange.oldValue == null || #namesChange.oldValue.isEmpty() || #namesChange.oldValue == '[]'">
                                                        <div class="empty-value-wrapper">No field mappings</div>
                                                    </s:if>
                                                    <s:else>
                                                        <div class="old-value-wrapper">
                                                            Previous mappings:
                                                            <s:set var="oldNamesStr" value="#namesChange.oldValue"/>
                                                            <s:set var="oldValuesStr" value="#valuesChange.oldValue"/>

                                                            <s:if test="#oldNamesStr.startsWith('[') && #oldNamesStr.endsWith(']') && #oldValuesStr.startsWith('[') && #oldValuesStr.endsWith(']')">
                                                                <s:set var="oldNamesContent" value="#oldNamesStr.substring(1, #oldNamesStr.length() - 1)"/>
                                                                <s:set var="oldValuesContent" value="#oldValuesStr.substring(1, #oldValuesStr.length() - 1)"/>
                                                                <s:set var="oldNamesArray" value="#oldNamesContent.split(', ')"/>
                                                                <s:set var="oldValuesArray" value="#oldValuesContent.split(', ')"/>

                                                                <div class="array-value">
                                                                    <s:iterator value="#oldNamesArray" var="fieldName" status="fieldStatus">
                                                                        <s:if test="#fieldName.trim().length() > 0">
                                                                            <s:set var="fieldValue" value="#oldValuesArray[#fieldStatus.index]"/>
                                                                            <span class="array-item field-pair">
                                                                                <strong><s:property value="#fieldName.trim()"/></strong>
                                                                                <span class="field-arrow">→</span>
                                                                                <s:property value="#fieldValue.trim()"/>
                                                                            </span>
                                                                        </s:if>
                                                                    </s:iterator>
                                                                </div>
                                                            </s:if>
                                                            <s:else>
                                                                Names: <s:property value="#namesChange.oldValue"/> | Values: <s:property value="#valuesChange.oldValue"/>
                                                            </s:else>
                                                        </div>
                                                    </s:else>

                                                    <%-- Current mapping --%>
                                                    <s:if test="#namesChange.newValue == null || #namesChange.newValue.isEmpty() || #namesChange.newValue == '[]'">
                                                        <div class="empty-value-wrapper">All field mappings removed</div>
                                                    </s:if>
                                                    <s:else>
                                                        <div class="new-value-wrapper">
                                                            Current mappings:
                                                            <s:set var="newNamesStr" value="#namesChange.newValue"/>
                                                            <s:set var="newValuesStr" value="#valuesChange.newValue"/>

                                                            <s:if test="#newNamesStr.startsWith('[') && #newNamesStr.endsWith(']') && #newValuesStr.startsWith('[') && #newValuesStr.endsWith(']')">
                                                                <s:set var="newNamesContent" value="#newNamesStr.substring(1, #newNamesStr.length() - 1)"/>
                                                                <s:set var="newValuesContent" value="#newValuesStr.substring(1, #newValuesStr.length() - 1)"/>
                                                                <s:set var="newNamesArray" value="#newNamesContent.split(', ')"/>
                                                                <s:set var="newValuesArray" value="#newValuesContent.split(', ')"/>

                                                                <div class="array-value">
                                                                    <s:iterator value="#newNamesArray" var="fieldName" status="fieldStatus">
                                                                        <s:if test="#fieldName.trim().length() > 0">
                                                                            <s:set var="fieldValue" value="#newValuesArray[#fieldStatus.index]"/>
                                                                            <span class="array-item field-pair">
                                                                                <strong><s:property value="#fieldName.trim()"/></strong>
                                                                                <span class="field-arrow">→</span>
                                                                                <s:property value="#fieldValue.trim()"/>
                                                                            </span>
                                                                        </s:if>
                                                                    </s:iterator>
                                                                </div>
                                                            </s:if>
                                                            <s:else>
                                                                Names: <s:property value="#namesChange.newValue"/> | Values: <s:property value="#valuesChange.newValue"/>
                                                            </s:else>
                                                        </div>
                                                    </s:else>
                                                </div>
                                            </s:if>

                                            <%-- Handle other fields --%>
                                            <s:iterator value="changes.entrySet()">
                                                <s:if test="!(key == 'idpUserProfileFieldNames' || key == 'idpUserProfileFieldValues') || !#hasFieldNames || !#hasFieldValues">
                                                    <div class="change-group">
                                                        <div class="field-name"><s:property value="key"/></div>
                                                        <s:if test="value.oldValue == value.newValue">
                                                            <span class="no-change">No Change: <s:property value="value.oldValue"/></span>
                                                        </s:if>
                                                        <s:else>
                                                            <%-- Check if this is an array/list field --%>
                                                            <s:if test="key == 'idpUserProfileFieldNames' || key == 'idpUserProfileFieldValues'">
                                                                <%-- Handle array/list fields specially (fallback for when only one exists) --%>
                                                                <s:if test="value.oldValue == null || value.oldValue.isEmpty() || value.oldValue == '[]'">
                                                                    <div class="empty-value-wrapper">No items</div>
                                                                </s:if>
                                                                <s:else>
                                                                    <div class="old-value-wrapper">
                                                                        Previous:
                                                                        <s:set var="oldArrayStr" value="value.oldValue"/>
                                                                        <s:if test="#oldArrayStr.startsWith('[') && #oldArrayStr.endsWith(']')">
                                                                            <s:set var="oldArrayContent" value="#oldArrayStr.substring(1, #oldArrayStr.length() - 1)"/>
                                                                            <div class="array-value">
                                                                                <s:iterator value="#oldArrayContent.split(', ')" var="item">
                                                                                    <s:if test="#item.trim().length() > 0">
                                                                                        <span class="array-item"><s:property value="#item.trim()"/></span>
                                                                                    </s:if>
                                                                                </s:iterator>
                                                                            </div>
                                                                        </s:if>
                                                                        <s:else>
                                                                            <s:property value="value.oldValue"/>
                                                                        </s:else>
                                                                    </div>
                                                                </s:else>

                                                                <s:if test="value.newValue == null || value.newValue.isEmpty() || value.newValue == '[]'">
                                                                    <div class="empty-value-wrapper">All items removed</div>
                                                                </s:if>
                                                                <s:else>
                                                                    <div class="new-value-wrapper">
                                                                        Current:
                                                                        <s:set var="newArrayStr" value="value.newValue"/>
                                                                        <s:if test="#newArrayStr.startsWith('[') && #newArrayStr.endsWith(']')">
                                                                            <s:set var="newArrayContent" value="#newArrayStr.substring(1, #newArrayStr.length() - 1)"/>
                                                                            <div class="array-value">
                                                                                <s:iterator value="#newArrayContent.split(', ')" var="item">
                                                                                    <s:if test="#item.trim().length() > 0">
                                                                                        <span class="array-item"><s:property value="#item.trim()"/></span>
                                                                                    </s:if>
                                                                                </s:iterator>
                                                                            </div>
                                                                        </s:if>
                                                                        <s:else>
                                                                            <s:property value="value.newValue"/>
                                                                        </s:else>
                                                                    </div>
                                                                </s:else>
                                                            </s:if>
                                                            <s:else>
                                                                <%-- Handle regular fields --%>
                                                                <s:if test="value.oldValue == null || value.oldValue.isEmpty()">
                                                                    <div class="empty-value-wrapper">Value was not set</div>
                                                                </s:if>
                                                                <s:else>
                                                                    <div class="old-value-wrapper"><s:property value="value.oldValue"/></div>
                                                                </s:else>

                                                                <s:if test="value.newValue == null || value.newValue.isEmpty()">
                                                                    <div class="empty-value-wrapper">Value cleared</div>
                                                                </s:if>
                                                                <s:else>
                                                                    <div class="new-value-wrapper"><s:property value="value.newValue"/></div>
                                                                </s:else>
                                                            </s:else>
                                                        </s:else>
                                                    </div>
                                                </s:if>
                                            </s:iterator>
                                        </s:if>
                                        <s:else>
                                            <p class="text-muted">No specific changes recorded for this entry.</p>
                                        </s:else>
                                    </div>
                                </td>
                            </tr>
                        </s:iterator>
                    </tbody>
                </table>
            </s:if>
            <s:else>
                <div class="alert alert-info m-3" role="alert">
                    <i class="bi bi-info-circle me-2"></i>
                    <s:if test="forLdapIdentifier != null && !forLdapIdentifier.isEmpty()">
                        No configuration history found for this LDAP identifier.
                    </s:if>
                    <s:else>
                        No LDAP configuration history available.
                    </s:else>
                </div>
            </s:else>
        </div>
    </div>
</div>

<!-- View Modal -->
<div class="modal-overlay" id="viewModal">
    <div class="modal-content">
        <div class="modal-header">
            <h3 class="modal-title">Configuration Changes</h3>
            <button class="modal-close" onclick="closeModal('viewModal')">&times;</button>
        </div>
        <div class="modal-body">
            <div class="change-details" id="viewModalContent">
                <!-- Content will be inserted by JavaScript -->
            </div>
        </div>
        <div class="modal-footer">
            <button class="btn-cancel" onclick="closeModal('viewModal')">Close</button>
        </div>
    </div>
</div>

<!-- Restore Confirmation Modal -->
<div class="modal-overlay" id="restoreModal">
    <div class="modal-content">
        <div class="modal-header">
            <h3 class="modal-title">Confirm Restore</h3>
            <button class="modal-close" onclick="closeModal('restoreModal')">&times;</button>
        </div>
        <div class="modal-body">
            <p>Are you sure you want to restore the configuration from <span id="restoreTimestamp" class="saved-at"></span>?</p>
            <p class="text-muted">This will replace your current configuration with the selected version.</p>
        </div>
        <div class="modal-footer">
            <button class="btn-cancel" onclick="closeModal('restoreModal')">Cancel</button>
            <form id="restoreForm" action="restore-history" method="post" class="d-inline">
                <s:if test="#parameters.ldapIdentifier != null">
                    <s:hidden name="ldapIdentifier" value="%{#parameters.ldapIdentifier}"/>
                </s:if>
                <s:elseif test="forLdapIdentifier != null">
                    <s:hidden name="ldapIdentifier" value="%{forLdapIdentifier}"/>
                </s:elseif>
                <input type="hidden" name="historyIdentifier" id="restoreHistoryId"/>
                <button type="submit" class="btn-confirm">Confirm Restore</button>
            </form>
        </div>
    </div>
</div>
