<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib prefix="s" uri="/struts-tags"%>
<html>
<head>
<link rel="stylesheet" href="css/style.css" />
<link rel="stylesheet" href="css/bootstrap/bootstrap.min.css" />
<link rel="shortcut icon" href="images/favicon.png">
<title>Configure miniOrange Gateway</title>
</head>
<body>
	<div class="header">
		<div class="container">
		<div class="row">
			<div class="col-md-1">
				<div class="logo"></div>
			</div>
			<div class="col-md-offset-10 col-md-1">
				<div id="logoutdiv" class="logout">
					<a href="adminlogout">Logout</a>
				</div>
			</div>
		</div>
	</div>
	<div class="container-fluid">
		<div class="row">
			<s:include value="menu.jsp">
				<s:param name="currentmenu" value="1" />
			</s:include>
			<div class="col-md-10 config_area">
				<div id="actionMessages">
					<s:if test="hasActionMessages()">
						<div id="display-success">
							<div class="alert alert-success alert-dismissible alert-custom"
								role="alert">
								<i class="glyphicon glyphicon-ok-circle icon-place glyph-size"></i>
								<button type="button" class="altloginclose" data-dismiss="alert">&times;</button>
								<s:actionmessage escape="false" />
							</div>
						</div>
					</s:if>
					<s:if test="hasActionErrors()">
						<div id="display-error">
							<div class="alert alert-warning alert-dismissible walter-custom"
								role="alert">
								<i
									class="glyphicon glyphicon-exclamation-sign icon-place glyph-size"></i>
								<button type="button" class="errormsgclose" data-dismiss="alert">&times;</button>
								<s:actionerror escape="false" />
							</div>
						</div>
					</s:if>
				</div>
				<div class="heading">Step 1: Configure miniOrange Gateway</div>
				<div class="panel panel-default">
					<div class="panel-heading">LDAP Connection Information</div>

					<s:form id="configureForm" action="configuremapping">

						<div class="login-group test-config">
							<div class="row row_custom">
								<div class="col-md-3 label-font">
									<span class="red">*</span> LDAP Server:
								</div>
								<div class="col-md-4">
									<s:textfield name="ldapServer" cssClass="form-control"
										placeholder="ldap://<server_address or IP>:<port>"
										required="true" />
								</div>
							</div>
							<br>
							<div class="row row_custom">
								<div class="col-md-3 label-font">
									<span class="red">*</span> Service Account DN:
								</div>
								<div class="col-md-4">
									<s:textfield name="bindAccountDN" cssClass="form-control"
										placeholder="CN=service,DC=domain,DC=com" required="true" />
								</div>
							</div>
							<br>
							<div class="row row_custom">
								<div class="col-md-3 label-font">
									<span class="red">*</span> Admin Password:
								</div>
								<div class="col-md-4">
									<s:textfield type="password" name="bindAccountPassword"
										cssClass="form-control"
										placeholder="Enter password of Service Account"
										required="true" />
								</div>
							</div>
							<br> <br>
							<div class="col-md-btn">
								<input type="submit" value="Test Connection and Save"
									class="btn btn-primary btn-grey" /> <a href="showusermapping"><input type="button"
									value="Next" class="btn btn-warning"/></a> 
							</div>
							<br> <br>
						</div>
					</s:form>
				</div>
			</div>
		</div>
	</div>
	<jsp:include page="footer.jsp" />
</body>
</html>