<%@ taglib prefix="s" uri="/struts-tags" %>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate"/>
    <meta http-equiv="Pragma" content="no-cache"/>
    <meta http-equiv="Expires" content="0"/>
    <link rel="shortcut icon" href="images/favicon.png">
    <title>Manage Secure LDAP Certificate</title>
    <link rel="stylesheet" href="css/style.css"/>
    <link rel="stylesheet" href="css/admin_style.css">
    <link rel="stylesheet" href="css/bootstrap/bootstrap5-0-2.min.css">
</head>
<body class="white">
<jsp:include page="header.jsp"/>
<div class="row me-0">
    <div class="col-md-2">
        <s:include value="menu.jsp">
            <s:param name="currentmenu" value="6"/>
        </s:include>
    </div>
    <div class="col-md-10 mt-4">
        <div class="container-fluid" id="actionMessages">
            <s:include value="actionmessages.jsp"/>
        </div>
        <div class="container-fluid">
            <div class="card ldap-panel shadow">
                <div class="card-header">
                    <h4 class="h4 mt-2">
                        Setup Secure LDAP <a href="https://www.miniorange.com/miniorange-ldap-gateway#step11"
                                             target="_blank">
                        <i class="fas fa-external-link-alt note-color mt-0 pt-0"></i></a>
                    </h4>
                </div>
                <div class="card-body">
                     <div class="alert alert-primary d-flex fade show info-left" role="alert">
                        <p class="h6 p-1 mt-2">&emsp;<i class="fa fa-info-circle"></i>
                            <ol class="ms-4 mt-2">
                                <li>Create Host entry with the Domain of your LDAP server.</li>
                                <li>Your Tomcat Server should be running with Admin Privileges.</li>
                            </ol>
                        </p>
                    </div>
                    <s:form id="configuresldaps" action="configureldaps">
                        <div class="login-group test-config">
                            <h5 class="h5 mt-2">Retrieve Certificate from Server:</h5><br/>
                            <div class="row">
                                <div class="col-md-3">
                                    <p class="input_field_fonts">Host:
                                        <a data-toggle="tooltip" title="Hostname of your LDAP Server">
                                            <i class="fas fa-info-circle"></i>
                                        </a>
                                    </p>
                                </div>
                                <div class="col-md-3">
                                    <s:textfield name="hostname" placeholder="Eg : ldaps.xecurify.com"
                                                 title="Hostname of your LDAP Server" cssClass="form-control"
                                                 autofocus="true" required="true"/>
                                </div>
                            </div>

                            <br>

                            <div class="row">
                                <div class="col-md-3">
                                    <p class="input_field_fonts">Port:
                                        <a data-toggle="tooltip" title="Port of your LDAP Server">
                                            <i class="fas fa-info-circle"></i>
                                        </a>
                                    </p>
                                </div>
                                <div class="col-md-3">
                                    <s:textfield type="number" name="port" placeholder="Eg : 636"
                                                 title="Port of your LDAP Server" cssClass="form-control"
                                                 autofocus="true" required="true"/>
                                </div>
                            </div>

                            <br>

                            <div class="row">
                                <div class="col-md-3">
                                    <p class="input_field_fonts">Alias:
                                        <a data-toggle="tooltip"
                                           title="Alias used to save Certificate in TrustStore">
                                            <i class="fas fa-info-circle"></i>
                                        </a>
                                    </p>
                                </div>
                                <div class="col-md-3">
                                    <s:textfield name="alias" placeholder="Eg : ldaps"
                                                 title="Alias used to save Certificate in TrustStore"
                                                 cssClass="form-control" autofocus="true" required="true"/>
                                </div>
                            </div>

                            <br>

                            <div class="row">
                                <div class="col-md-3">
                                    <p class="input_field_fonts">Password:
                                        <a data-toggle="tooltip" title="Password of your TrustStore">
                                            <i class="fas fa-info-circle"></i>
                                        </a>
                                    </p>
                                </div>
                                <div class="col-md-3">
                                    <s:password name="password"
                                                title="Password of the TrustStore" cssClass="form-control"
                                                autofocus="true" required="true"/>
                                </div>
                            </div>

                            <br>

                            <div class="row">
                                <div class="col-md-5 col-md-offset-3">
                                    <input type="submit" value="Fetch Certificate"
                                           class="btn btn-primary orange-btn"/>
                                </div>
                            </div>
                            <br> <br>

                        </div>
                    </s:form>
                </div>
            </div>
        </div>
    </div>
</div>
<jsp:include page="footer.jsp"/>
</body>
</html>
