<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib prefix="s" uri="/struts-tags" %>
<!DOCTYPE html>
<html>
<head>
    <link rel="stylesheet" href="css/style.css"/>
    <link rel="stylesheet" href="css/bootstrap/bootstrap5-0-2.min.css">
    <link rel="stylesheet" href="css/bootstrap/bootstrap-switch.min.css"/>
    <link rel="stylesheet" href="css/admin_style.css">
    <link rel="shortcut icon" href="images/favicon.png">
    <title>Configure Schedules</title>
</head>
<body class="white">
<div id="loading_image" class="collapse">
    <div class="loadingbar"></div>
</div>
<jsp:include page="header.jsp"/>
<div class="row me-0">
    <div class="col-md-2">
        <s:include value="menu.jsp">
            <s:param name="currentmenu" value="3"/>
        </s:include>
    </div>
    <div class="col-md-10 mt-4">
        <div class="container-fluid" id="actionMessages">

            <s:include value="actionmessages.jsp"/>

        </div>
        <div class="container-fluid">
            <div class="card ldap-panel shadow">
                <div class="card-header">
                    <h4 class="mt-2 h4">Configure LDAP-miniOrange Sync
                        <a href="https://www.miniorange.com/miniorange-ldap-gateway#step9" target="_blank">
                            <i class="fas fa-external-link-alt note-color mt-0 pt-0"></i>
                        </a>
                    </h4>
                </div>
                <div class="card-body">

                    <nav>
                        <div class="nav nav-tabs" id="nav-tab" role="tablist">
                            <button class="nav-link active" id="configure-schedule-tab" data-bs-toggle="tab" data-bs-target="#configure-schedule" type="button" role="tab" aria-controls="nav-home" aria-selected="true" href="#configureSchecduleTab">Configure LDAP Sync</button>
                            <button class="nav-link" id="schedule-type-tab" data-bs-toggle="tab" data-bs-target="#schedule-type" type="button" role="tab" aria-controls="nav-profile" aria-selected="false" href="#scheduleTypeTab">Enable LDAP Sync</button>
                        </div>
                    </nav>
                    <div class="tab-content" id="nav-tabContent">
                        <div class="tab-pane fade show active" id="configure-schedule" role="tabpanel" aria-labelledby="nav-home-tab">
                            <s:form id="configureschedules" action="saveschedules" method="post">
                                <div class="login-group test-config"><br/><br/>
                                    <div class="row">
                                        <div class="col-md-3">
                                            <p class="input_field_fonts">Enable Group Sync:
                                                <a data-bs-toggle="tooltip"
                                                   title="Enable Group Sync allows to sync groups from Active Directory to miniOrange automatically on a regular time interval">
                                                    <i class="fas fa-info-circle"></i>
                                                </a>
                                            </p>
                                        </div>
                                        <div class="col-md-3">
                                            <label class="switch">
                                                <s:checkbox id="syncGroupsCreate"
                                                            name="syncGroupsCreate"
                                                            value="%{syncGroupsCreate}"
                                                />
                                                <div class="slider round"></div>
                                            </label>
                                        </div>
                                    </div>
                                    <br/>
                                    <div class="row">
                                        <div class="col-md-3">
                                            <p class="input_field_fonts">Enable User Sync:
                                                <a data-bs-toggle="tooltip"
                                                   title="Enable Sync allows you to sync users from Active Directory to miniOrange automatically on a regular time interval">
                                                    <i class="fas fa-info-circle"></i>
                                                </a>
                                            </p>
                                        </div>
                                        <div class="col-md-3">
                                            <label class="switch">
                                                <s:checkbox id="isSyncEnabled"
                                                            name="isSyncEnabled"
                                                            value="%{isSyncEnabled}" onChange="displayOptions()"
                                                />
                                                <div class="slider round"></div>
                                            </label>
                                        </div>
                                    </div>
                                    <br/>
                                    <div id="enableOptions" <s:if test= "!isSyncEnabled"> style='display: none'</s:if> >
                                        <div class="row">
                                            <div class="col-md-3">
                                                <p class="input_field_fonts">Enable User Group Membership Sync:
                                                    <a data-bs-toggle="tooltip"
                                                       title="Enable User Group Membership Sync allows you to sync users' group membership from Active Directory and auto-assign them into groups in miniOrange">
                                                        <i class="fas fa-info-circle"></i>
                                                    </a>
                                                </p>
                                            </div>
                                            <div class="col-md-3">
                                                <label class="switch">
                                                    <s:checkbox id="syncGroupsEnable"
                                                                name="syncGroupsEnable"
                                                                value="%{syncGroupsEnable}" onChange="displayNestedGroupsOptions()"
                                                    />
                                                    <div class="slider round"></div>
                                                </label>
                                            </div>
                                        </div>

                                        <br/>
                                        <div id="enableNestedGroupsOptions" <s:if test= "!syncGroupsEnable"> style='display: none'</s:if> >
                                            <div class="row">
                                                <div class="col-md-3">
                                                    <p class="input_field_fonts">Enable Import Nested Groups:
                                                        <a data-bs-toggle="tooltip"
                                                           title="Enable Import Nested Groups option allows you to sync users group membership from Active Directory and auto-assign them into groups and their parent groups in miniOrange in nested manner">
                                                            <i class="fas fa-info-circle"></i>
                                                        </a>
                                                    </p>
                                                </div>
                                                <div class="col-md-3">
                                                    <label class="switch">
                                                        <s:checkbox id="importNestedGroups"
                                                                    name="importNestedGroups"
                                                                    value="%{importNestedGroups}"
                                                        />
                                                        <div class="slider round"></div>
                                                    </label>
                                                </div>
                                            </div>
                                        </div>

                                        <br/>
                                        <div class="row">
                                            <div class="col-md-3">
                                                <p class="input_field_fonts">Enable Delete User Sync:
                                                    <a data-bs-toggle="tooltip"
                                                       title="Enable Delete User Sync allows the deletion of users in miniOrange when the users are deleted in the Active Directory">
                                                        <i class="fas fa-info-circle"></i>
                                                    </a>
                                                </p>
                                            </div>
                                            <div class="col-md-3">
                                                <label class="switch">
                                                    <s:checkbox id="enableDeleteSync"
                                                                name="enableDeleteSync"
                                                                value="%{enableDeleteSync}" onChange="displayDeleteOptions()"/>
                                                    <div class="slider round"></div>
                                                </label>
                                            </div>
                                        </div>
                                        <br/>

                                        <div id="enableDeleteOptions" <s:if test= "!enableDeleteSync"> style='display: none'</s:if> >
                                            <div class="row">
                                                <div class="col-md-3">
                                                    <p class="input_field_fonts">Configure Exclusion List:
                                                        <a data-bs-toggle="tooltip"
                                                           title="Choose which miniOrange users you want to exclude from being deleted due to the sync. These users are the ones that are present only in miniOrange.">
                                                            <i class="fas fa-info-circle"></i>
                                                        </a>
                                                    </p>
                                                </div>
                                                <div class="col-md-3">
                                                    <a id="fetchSelectedUser" class="btn btn-primary orange-btn" data-bs-toggle="modal" data-bs-target="#selectUsers">Select Users</a>
                                                </div>
                                            </div>
                                            <br>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-3">
                                                <p class="input_field_fonts">Sync Enable/Disable Status:
                                                    <a data-bs-toggle="tooltip"
                                                       title="Enable this will sync the user account status and enable or disable the user in miniOrange accordingly">
                                                        <i class="fas fa-info-circle"></i>
                                                    </a>
                                                </p>
                                            </div>
                                            <div class="col-md-3">
                                                <label class="switch">
                                                    <s:checkbox id="enableDisableStatusSync"
                                                                name="enableDisableStatusSync"
                                                                value="%{enableDisableStatusSync}"/>
                                                    <div class="slider round"></div>
                                                </label>
                                            </div>
                                        </div>
                                        <br/>
                                        <div class="row">
                                            <div class="col-md-3">
                                                <p class="input_field_fonts">Sync Locked/Unlocked Status:
                                                    <a data-bs-toggle="tooltip"
                                                       title="Enable this will sync the user account lockout status in miniOrange accordingly">
                                                        <i class="fas fa-info-circle"></i>
                                                    </a>
                                                </p>
                                            </div>
                                            <div class="col-md-3">
                                                <label class="switch">
                                                    <s:checkbox id="enableLockoutStatusSync"
                                                                name="enableLockoutStatusSync"
                                                                value="%{enableLockoutStatusSync}"/>
                                                    <div class="slider round"></div>
                                                </label>
                                            </div>
                                        </div>
                                        <br/>
                                    </div>
                                    <div class="modal" role="dialog" tabindex="-1" aria-labelledby="selectUsers" aria-hidden="true"
                                         data-backdrop="false" id="selectUsers">
                                        <div class="modal-dialog">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title">Select Users To Persist in miniOrange</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <div class="filter-wrapper row">
                                                        <div class="col-md-6">
                                                        <span class="pull-left search-wrapper">
                                                            <input name="search" id="logssearchbox" class="logssearchbox" onkeyup="searchUsers(this.value,0)" placeholder="Search">
                                                            <buttom class="srch-btn"><i class="glyphicon glyphicon-search ldap-search"></i></buttom>
                                                        </span>
                                                        </div>

                                                    </div>

                                                    <div class="row">
                                                        <table id="example" class="table table-hover table-condensed tablewrap table_header_font logs-table table-bordered">
                                                            <thead>
                                                            <tr>
                                                                <th><input id="select_all" value="1" type="checkbox"></th>
                                                                <th>Username</th>
                                                                <th>Email</th>
                                                            </tr>
                                                            </thead>
                                                            <tbody>
                                                            </tbody>
                                                        </table>

                                                      <s:hidden id="usernameEmailList" value="%{usernameEmailListJSON}" name="usernameEmailList"/>
                                                        <div class="no-record-found">
                                                            <h3 class="text-center">No Records Found!!</h3>
                                                        </div>
                                                         <div class="no-user-found">
                                                            <h3 class="text-center">No Users Found!!</h3>
                                                        </div>

                                                        <input type="hidden" id="miniorangeUsersList" name="miniorangeUsersList" value="">
                                                    </div>

                                                </div>
                                                <div class="pagination-wrapper" id="pagination-wrapper">
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-default" data-bs-dismiss="modal">Cancel</button>
                                                    <button id="deleteLdapSubmit" type="button" class="btn btn-primary btn-cnfrm" onclick="bulkaction()" data-bs-dismiss="modal">Apply</button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-3">
                                            <p class="input_field_fonts">Start Time(hh:mm):<span style="color:red">*</span>
                                                <a data-bs-toggle="tooltip"
                                                   title="Specify start time for scheduler in 24 hr format">
                                                    <i class="fas fa-info-circle"></i>
                                                </a>
                                            </p>
                                        </div>
                                        <div class="col-md-3">
                                            <s:select list="syncHoursList" name="syncHours" headerKey=""
                                                      headerValue="Select Hour" cssClass="form-select" required="true"
                                                      value="%{syncHours}"/>
                                        </div>
                                        <div class="col-md-3">
                                            <s:select list="syncMinList" name="syncMins" headerKey=""
                                                      headerValue="Select Minutes" cssClass="form-select" placeholder="mm"
                                                      required="true" value="%{syncMins}"/>
                                        </div>
                                    </div>
                                    <br/>
                                    <div class="row">
                                        <div class="col-md-3">
                                            <p class="input_field_fonts">Sync Interval (in minutes):<span style="color:red">*</span>
                                                <a data-bs-toggle="tooltip"
                                                   title="Interval at which scheduled sync repeats after start time.">
                                                    <i class="fas fa-info-circle"></i>
                                                </a>
                                            </p>
                                        </div>
                                        <div class="col-md-3">
                                            <s:textfield type = "number" name="syncInterval" id="syncInterval" cssClass="form-control" placeholder="Sync Interval in minutes"
                                                         title="Sync Interval (in minutes):" required="true"  value="%{syncInterval}"  />
                                            <p id="error-message" class="red d-none">The value must be between 15 and 1380 (15 minutes to 23 hours).</p>
                                        </div>
                                    </div>
                                    <br/>
                                    <div class="row">
                                        <div class="col-md-5 col-md-offset-3">
                                            <input type="submit" value="Save"
                                                   class="btn btn-primary orange-btn"/> <a href="viewldaplist"></a>
                                        </div>
                                    </div>
                                    <br> <br>
                                </div>
                            </s:form>
                        </div>
                        <div class="tab-pane fade" id="schedule-type" role="tabpanel" aria-labelledby="nav-profile-tab">
                            <br>
                            <div class="container">
                                <s:if test="gatewayConfigurationList.size > 0">
                                    <div <s:if test="isAddToScheduler">hidden</s:if>>
                                        <div class="alert alert-primary" role="alert">
                                            <i class="fa fa-info-circle"></i>&nbsp; All LDAP configuration for Sync are Disabled. Please enable atleast one LDAP configuration to perform Sync actions.
                                        </div>
                                    </div>
                                </s:if>
                                <s:else>
                                    <div>
                                        <div class="alert alert-primary" role="alert">
                                            <i class="fa fa-info-circle"></i>&nbsp; LDAP Connection is not configured. Please configure LDAP Connection by clicking on LDAP Connection in the side menu.
                                        </div>
                                    </div>
                                </s:else>

                                <div class="row">
                                    <div class="col-lg-6 mb-4">
                                        <div class="card text-dark bg-light mb-3">
                                            <img class="card-img-top" src="" alt="">
                                            <div class="card-body">
                                                <h5 class="card-title">Scheduled Sync</h5>
                                                <s:form id="scheduledsyncform" action="runscheduledsync" method="post">
                                                    <p class="card-text">
                                                        Click the button below to perform scheduled sync according to the configurations.
                                                    </p>
                                                    <s:if test="isAddToScheduler">
                                                        <input type="submit"
                                                                <s:if test='enableScheduledSync'>
                                                                    name="disable_scheduled_sync_button" value="Disable Scheduled Sync" class="btn btn-primary orange-btn"
                                                                </s:if>
                                                                <s:else>
                                                                    name="enable_scheduled_sync_button" value="Enable Scheduled Sync" class="btn btn-primary orange-btn"
                                                                </s:else>
                                                        />
                                                    </s:if>
                                                    <s:else>
                                                        <input disabled name="enable_scheduled_sync_button" value="Enable Scheduled Sync" class="btn btn-primary orange-btn" />
                                                    </s:else>
                                                </s:form>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-6 mb-4">
                                        <div class="card text-dark bg-light mb-3">
                                            <img class="card-img-top" src="" alt="">
                                            <div class="card-body">
                                                <h5 class="card-title">One-Time Sync</h5>
                                                <s:form id="onetimesyncform" action="runonetimesync" method="post">
                                                    <p class="card-text">
                                                        Click the button below to perform one-time sync according to the configurations.
                                                    </p>
                                                    <s:if test="isAddToScheduler">
                                                        <input value="Run One-time Sync"  type="submit"
                                                               class="btn btn-primary orange-btn"/>
                                                    </s:if>
                                                    <s:else>
                                                        <input disabled value="Run One-time Sync"
                                                               class="btn btn-primary orange-btn"/>
                                                    </s:else>
                                                </s:form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<jsp:include page="footer.jsp"/>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="js/schedule-config.js"></script>
</body>
</html>