<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib prefix="s" uri="/struts-tags" %>
<!DOCTYPE html>
<html>
<head>
    <link rel="stylesheet" href="css/style.css"/>
    <link rel="stylesheet" href="css/bootstrap/bootstrap5-0-2.min.css">
    <link rel="stylesheet" href="css/admin_style.css">
    <link rel="shortcut icon" href="images/favicon.png">
    <title>Edit LDAP Configuration</title>
</head>
<body class="white">
<jsp:include page="header.jsp"/>
<script src="${pageContext.request.contextPath}/js/select2.min.js"></script>
<link href='${pageContext.request.contextPath}/css/select2.min.css' rel='stylesheet' type='text/css'>
<div class="row me-0">
    <div class="col-md-2">
        <s:include value="menu.jsp">
            <s:param name="currentmenu" value="1"/>
        </s:include>
    </div>
    <div class="col-md-10 mt-4">
        <div class="container-fluid" id="actionMessages">
            <s:include value="actionmessages.jsp"/>
        </div>
        <div class="container-fluid">
            <div class="card ldap-panel mb-2">
                <div class="card-header">
                    <h4>Edit LDAP Configuration
                        <a href="https://www.miniorange.com/miniorange-ldap-gateway#step6" target="_blank">
                            <i class="fas fa-external-link-alt note-color mt-0 pt-0"></i>
                        </a>
                    </h4>
                </div>
                <div class="card-body">
                    <div class="alert alert-primary" role="alert">
                        <i class="fa fa-info-circle"></i>&nbsp; Add a connection to Directory like Active Directory, OpenLDAP, Azure AD, Free IPA.
                    </div>
                    <form id="updateldapconfig" action="updateldapconfig" method="post">
                        <s:hidden name="ldapbinduserstoreoperation" id="ldapbinduserstoreoperation"></s:hidden>
                        <jsp:include page="ldapconfiguration.jsp"/>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<jsp:include page="footer.jsp"/>
</body>
<script>
  $( document ).ready(function() {
    $("#ldapbinduserstoreoperation").val("editldapconfig");

 });
</script>
</html>