<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib prefix="s" uri="/struts-tags"%>
<html>
<head>
<link rel="stylesheet" href="css/style.css" />
<link rel="stylesheet" href="css/bootstrap/bootstrap.min.css" />
<link rel="shortcut icon" href="images/favicon.png">
<link rel="stylesheet" href="css/datepicker.css">
<title>Export Users</title>
</head>
<body>
	<div class="header">
		<div class="container">
		<div class="row">
			<div class="col-md-1">
				<div class="logo"></div>
			</div>
			<div class="col-md-offset-10 col-md-1">
				<div id="logoutdiv" class="logout">
					<a href="adminlogout">Logout</a>
				</div>
			</div>
		</div>
		</div>
	</div>
	<div class="container-fluid">
		<div class="row">
			<s:include value="menu.jsp">
				<s:param name="currentmenu" value="5" />
			</s:include>
			<div class="col-md-10 config_area">
			<div id="actionMessages">
				<s:if test="hasActionMessages()">
					<div id="display-success">
						<div class="alert alert-success alert-dismissible alert-custom"
							role="alert">
							<i class="glyphicon glyphicon-ok-circle glyph_pos "></i>
							<button type="button" class="altloginclose" data-dismiss="alert">&times;</button>
							<s:actionmessage escape="false" />
						</div>
					</div>
				</s:if>
				<s:if test="hasActionErrors()">
					<div id="display-error">
						<div class="alert alert-warning alert-dismissible walter-custom"
							role="alert">
							<i
								class="glyphicon glyphicon-exclamation-sign icon-place glyph-size"></i>
							<button type="button" class="errormsgclose" data-dismiss="alert">&times;</button>
							<s:actionerror escape="false" />
						</div>
					</div>
				</s:if>
			</div>			
				<div class="heading">Export Users in CSV</div>
				<div class="panel panel-default">
					<div class="panel-body">
					<div>
						<h4>Export users created between <b>From</b> and <b>To</b> dates in CSV</h4>
					</div><br>
						<s:form id="exportUsers" action="exportusers">
							<div class="col-md-8 ">
								
								<div class="row row_custom">
									<div class="col-md-4 label-font">
										<span class="red">*</span> From:
									</div>
									<div class="col-md-4">
										<s:textfield name="fromDate" cssClass="form-control dp1"
											placeholder="yyyy-MM-dd" required="true" />
									</div>
								</div>
								<br>
								<div class="row row_custom">
									<div class="col-md-4 label-font">
										<span class="red">*</span> To:
									</div>
									<div class="col-md-4">
										<s:textfield name="toDate" cssClass="form-control dp2"
											placeholder="yyyy-MM-dd" required="true" />
									</div>
								</div>
								<br> <br>
								<div class="col-md-btn">
									<s:submit value="Export" cssClass="btn btn-warning" />
								</div>
								
							</div>
						</s:form>
					</div>
				</div>
			</div>
		</div>
	</div>
	<jsp:include page="footer.jsp" />
	<script src="js/bootstrap-datepicker.js"></script>
	<script>
		$(document).ready(function(){
			$('.dp1').datepicker({
				format:'yyyy-mm-dd'
		   	}).on('changeDate', function (ev) {
				$(this).datepicker('hide');
			});
			$('.dp2').datepicker({
				format:'yyyy-mm-dd'
		   	}).on('changeDate', function (ev) {
				$(this).datepicker('hide');
		});
		});
	</script>
</body>
</html>