<%@ taglib prefix="s" uri="/struts-tags" %>
<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>LDAP Configuration History</title>
    <link rel="stylesheet" href="css/style.css"/>
    <link rel="stylesheet" href="css/admin_style.css"/>
    <link rel="stylesheet" href="css/bootstrap/bootstrap5-0-2.min.css"/>
    <link rel="shortcut icon" href="images/favicon.png">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.8.1/font/bootstrap-icons.css">
    <link rel="stylesheet" href="css/gatewayhistory.css"/>
    <style>
        .ldap-sidebar {
            background: #fff;
            border-right: 1px solid #dee2e6;
            height: calc(100vh - 80px);
            overflow-y: auto;
            padding: 0;
        }

        .ldap-sidebar-header {
            background: #f8f9fa;
            padding: 1rem;
            border-bottom: 1px solid #dee2e6;
            font-weight: 600;
            color: #495057;
            font-size: 0.9rem;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .ldap-identifier-list {
            list-style: none;
            padding: 0;
            margin: 0;
        }

        .ldap-identifier-item {
            border-bottom: 1px solid #f1f3f4;
        }

        .ldap-identifier-link {
            display: block;
            padding: 0.875rem 1rem;
            text-decoration: none;
            color: #495057;
            transition: all 0.2s ease;
            position: relative;
        }

        .ldap-identifier-link:hover {
            background: #f8f9fa;
            color: #0d6efd;
            text-decoration: none;
        }

        .ldap-identifier-link.active {
            background: #0d6efd;
            color: white;
            border-left: 4px solid #0a58ca;
        }

        .ldap-identifier-link.active:hover {
            background: #0b5ed7;
            color: white;
        }

        .identifier-name {
            font-weight: 500;
            font-size: 0.9rem;
            word-break: break-word;
        }

        .identifier-meta {
            font-size: 0.75rem;
            opacity: 0.7;
            margin-top: 0.25rem;
        }

        .active .identifier-meta {
            opacity: 0.9;
        }

        .history-content-area {
            padding-left: 0;
        }

        .no-identifier-selected {
            display: flex;
            align-items: center;
            justify-content: center;
            height: 400px;
            flex-direction: column;
            color: #6c757d;
            text-align: center;
        }

        .no-identifier-selected i {
            font-size: 3rem;
            margin-bottom: 1rem;
            opacity: 0.5;
        }

        @media (max-width: 768px) {
            .ldap-sidebar {
                height: auto;
                border-right: none;
                border-bottom: 1px solid #dee2e6;
            }

            .ldap-identifier-link {
                padding: 0.75rem 1rem;
            }
        }

        .sidebar-search {
            padding: 1rem;
            border-bottom: 1px solid #dee2e6;
        }

        .sidebar-search input {
            width: 100%;
            padding: 0.5rem 0.75rem;
            border: 1px solid #ced4da;
            border-radius: 0.25rem;
            font-size: 0.875rem;
        }

        .sidebar-search input:focus {
            border-color: #0d6efd;
            box-shadow: 0 0 0 0.2rem rgba(13, 110, 253, 0.25);
            outline: 0;
        }

        .identifier-badge {
            display: inline-block;
            background: rgba(255, 255, 255, 0.2);
            color: inherit;
            padding: 0.125rem 0.5rem;
            border-radius: 12px;
            font-size: 0.7rem;
            margin-top: 0.25rem;
        }

        .active .identifier-badge {
            background: rgba(255, 255, 255, 0.3);
        }
    </style>
</head>
<body class="white">
    <jsp:include page="header.jsp"/>
    <div class="row me-0">
        <div class="col-md-2">
            <s:include value="menu.jsp">
                <s:param name="currentmenu" value="2"/>
            </s:include>
        </div>
        <div class="col-md-10 mt-4">
            <div class="container-fluid" id="actionMessages">
                <s:include value="actionmessages.jsp"/>
            </div>
            <div class="container-fluid">
                <div class="container-fluid mb-3">
                    <a href="viewldaplist" class="btn btn-outline-secondary">
                        <i class="bi bi-arrow-left"></i> Back
                    </a>
                </div>
                <jsp:include page="changes.jsp"/>
            </div>
        </div>
    </div>
    <jsp:include page="footer.jsp"/>

    <!-- View Modal -->
    <div class="modal-overlay" id="viewModal">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="modal-title">Configuration Changes</h3>
                <button class="modal-close" onclick="closeModal('viewModal')">&times;</button>
            </div>
            <div class="modal-body">
                <div class="change-details" id="viewModalContent">
                    <!-- Content will be inserted by JavaScript -->
                </div>
            </div>
            <div class="modal-footer">
                <button class="btn-cancel" onclick="closeModal('viewModal')">Close</button>
            </div>
        </div>
    </div>

    <!-- Restore Confirmation Modal -->
    <div class="modal-overlay" id="restoreModal">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="modal-title">Confirm Restore</h3>
                <button class="modal-close" onclick="closeModal('restoreModal')">&times;</button>
            </div>
            <div class="modal-body">
                <p>Are you sure you want to restore the configuration from <span id="restoreTimestamp" class="saved-at"></span>?</p>
                <p class="text-muted">This will replace your current configuration with the selected version.</p>
            </div>
            <div class="modal-footer">
                <button class="btn-cancel" onclick="closeModal('restoreModal')">Cancel</button>
                <form id="restoreForm" action="restore-history" method="post" class="d-inline">
                    <s:hidden name="ldapIdentifier" value="%{#parameters.ldapIdentifier}"/>
                    <input type="hidden" name="historyIdentifier" id="restoreHistoryId"/>
                    <button type="submit" class="btn-confirm">Confirm Restore</button>
                </form>
            </div>
        </div>
    </div>

    <script src="js/bootstrap/bootstrap5-0-2.bundle.min.js"></script>
    <script src="js/gatewayhistory.js"></script>
    <script>
        document.getElementById('identifierSearch').addEventListener('input', function(e) {
            const searchTerm = e.target.value.toLowerCase();
            const identifierItems = document.querySelectorAll('.ldap-identifier-item');

            identifierItems.forEach(function(item) {
                const identifierName = item.querySelector('.identifier-name').textContent.toLowerCase();
                if (identifierName.includes(searchTerm)) {
                    item.style.display = 'block';
                } else {
                    item.style.display = 'none';
                }
            });
        });
    </script>
</body>
</html>
