<%@ taglib prefix="s" uri="/struts-tags" %>

<div class="deployment-section-profile-page mt-3 deployment-section">
    <div class="d-flex justify-content-center">
        <div class="text-center mb-3">
            <div class="btn-group" role="group">
                <label class="btn orange-btn btn-cloud">
                    <input type="radio" name="deploymentType" value="cloud" checked> Cloud
                </label>
                <label class="btn orange-btn-outline btn-onpremise">
                    <input type="radio" name="deploymentType" value="onpremise"> On-Premise
                </label>
            </div>
        </div>
    </div>

    <div class="zone-selector mt-3 w-75 mx-auto">
        <div>Server Zone</div>
        <select id="zoneSelect" name="zoneSelect" class="form-select">
            <option value="">Select Cloud Zone</option>
            <option value="usa" selected>USA (Default)</option>
            <s:iterator value="cloudZonesUrls.keySet()" var="zone">
                <s:if test="#zone != 'usa'">
                    <option value="<s:property value="#zone"/>">
                        <s:set var="capitalizedZone" value="#zone.substring(0,1).toUpperCase() + #zone.substring(1).toLowerCase()" />
                        <s:property value="#capitalizedZone"/>
                    </option>
                </s:if>
            </s:iterator>
            <option value="others">Custom/Vanity</option>
        </select>
    </div>

    <div class="mt-3 mb-3 w-75 mx-auto">
        <label class="form-label">IDP URL</label>
        <input type="text" id="idpUrl" name="idpUrl" class="form-control url-display"
               pattern="^(http|https):\/\/[^\s/$.?#].[^\s]*$"
               title="Please enter a valid URL starting with http:// or https://">
        <div class="invalid-feedback">
            Please enter a valid URL starting with http:// or https:// (e.g., http://youridp.example.com)
        </div>
    </div>
</div>


<script>

$(document).ready(function () {
    if ($('.deployment-section, .deployment-section-profile-page').length) {
        $('input[name="deploymentType"]').change(function () {
            const isCloud = $(this).val() === 'cloud';
            $('.btn-cloud').toggleClass('orange-btn', isCloud).toggleClass('orange-btn-outline', !isCloud);
            $('.btn-onpremise').toggleClass('btn-orange', !isCloud).toggleClass('btn-outline-orange', isCloud);
            $('.zone-selector').toggle(isCloud);
            $('#idpUrl').prop('readonly', isCloud).toggleClass('url-display', isCloud);
            if (isCloud) $('#zoneSelect').trigger('change');
            if (!isCloud) $('#idpUrl').val('');
        });

        $('#zoneSelect').change(function () {
            const selectedZone = $(this).val() || 'usa';
            const zoneUrls = JSON.parse($('#cloudZonesUrlsJSON').val());
            $('#idpUrl').val(zoneUrls[selectedZone] || '');
        });

        $('#idpUrl').on('input', function () {
            const isValid = /^(http|https):\/\/[^\s/$.?#].[^\s]*$/i.test($(this).val().trim());
            $(this).toggleClass('is-invalid', !isValid).toggleClass('is-valid', isValid);
        });

        $('input[name="deploymentType"]:checked').trigger('change');
    }
});


$(document).ready(function () {
    const $idpUrl = $('#idpUrl');
    const $zoneSelector = $('#zoneSelect');
    const zoneUrls = JSON.parse($('#cloudZonesUrlsJSON').val() || '{}');

    function updateIdpUrl() {
        const type = $('input[name="deploymentType"]:checked').val();
        const zone = $zoneSelector.val();

        $idpUrl.removeClass('is-valid is-invalid');

        if (type === 'cloud') {
            $('.zone-selector').show();

            if (zone === 'others') {
                $idpUrl.val('').prop('readonly', false)
                       .attr('placeholder', 'https://vanity-url.com');
            } else {
                $idpUrl.val(zoneUrls[zone] || '')
                       .prop('readonly', true)
                       .attr('placeholder', '');
            }

        } else {
            $('.zone-selector').hide();
            $idpUrl.val('').prop('readonly', false)
                   .attr('placeholder', 'http://127.0.0.1');
        }
    }

    $('input[name="deploymentType"]').change(function () {
        updateButtonStyles();
        updateIdpUrl();
    });

    $zoneSelector.change(updateIdpUrl);

function updateButtonStyles() {
    const isCloud = $('input[name="deploymentType"]:checked').val() === 'cloud';

    // Cloud selected
    $('.btn-cloud')
        .removeClass('orange-btn-outline')
        .addClass('orange-btn');

    $('.btn-onpremise')
        .removeClass('orange-btn')
        .addClass('orange-btn-outline');

    if (!isCloud) {
        // On-Premise selected
        $('.btn-cloud')
            .removeClass('orange-btn')
            .addClass('orange-btn-outline');

        $('.btn-onpremise')
            .removeClass('orange-btn-outline')
            .addClass('orange-btn');
    }
}

    $('input[name="deploymentType"]:checked').trigger('change');
});


</script>