
var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
    return new bootstrap.Tooltip(tooltipTriggerEl);
});

$(document).ready(function() {
    $("#logSettingsForm").validate({
        rules: {
            rotatedLogPath: {
                required: true
            },
            logRetentionPeriod: {
                required: true,
                min: 1
            }
        },
        messages: {
            rotatedLogPath: "Please enter a valid log path",
            logRetentionPeriod: {
                required: "Please enter retention period",
                min: "Retention period must be at least 1 day"
            }
        }
    });
});


document.addEventListener("DOMContentLoaded", function () {
    const enableCheckbox = document.getElementById("enableLogRetention");
    const retentionRow = document.getElementById("retentionDaysRow");
    const retentionInput = document.getElementById("logRetentionPeriod");

    function toggleRetentionDays() {
        if (enableCheckbox.checked) {
            retentionRow.classList.add("show");
            retentionInput.disabled = false;
        } else {
            retentionRow.classList.remove("show");
            retentionInput.disabled = true;
        }
    }

    if (enableCheckbox && retentionRow && retentionInput) {
        enableCheckbox.addEventListener("change", toggleRetentionDays);
        toggleRetentionDays();
    }
});
