$(document).ready(function () {
    const $zoneSelector = $('#zoneSelect');
    const $cloudZonesJson = $('#cloudZonesUrlsJSON');
    const $idpUrl = $('#idpUrl');

    function isValidUrl(url) {
        const urlPattern = /^(http|https):\/\/[^\s/$.?#].[^\s]*$/i;
        return urlPattern.test(url);
    }

    $zoneSelector.change(function () {
        const selectedZone = $(this).val() || 'usa';
        let zoneUrls = {};
        try {
            zoneUrls = JSON.parse($cloudZonesJson.val());
        } catch (e) {
        }

        $idpUrl.val(zoneUrls[selectedZone] || '');
    });

    $zoneSelector.trigger('change');
});
