let sortAsc = true;

function sortTableByDate() {
    const table = document.querySelector('.history-table tbody');
    const rows = Array.from(table.querySelectorAll('tr'));

    rows.sort((a, b) => {
        const dateA = new Date(a.querySelector('.saved-at').textContent.trim());
        const dateB = new Date(b.querySelector('.saved-at').textContent.trim());

        return sortAsc ? dateA - dateB : dateB - dateA;
    });

    table.innerHTML = '';
    rows.forEach(row => table.appendChild(row));

    sortAsc = !sortAsc;
}

function openViewModal(index) {
    const changeData = document.getElementById('changeData-' + index).innerHTML;
    document.getElementById('viewModalContent').innerHTML = changeData;
    document.getElementById('viewModal').classList.add('active');
    document.body.style.overflow = 'hidden';
}

function openRestoreModal(historyId, timestamp) {
    document.getElementById('restoreHistoryId').value = historyId;
    document.getElementById('restoreTimestamp').textContent = timestamp;
    document.getElementById('restoreModal').classList.add('active');
    document.body.style.overflow = 'hidden';
}

function closeModal(modalId) {
    document.getElementById(modalId).classList.remove('active');
    document.body.style.overflow = 'auto';
}

document.addEventListener('DOMContentLoaded', function() {
    document.querySelectorAll('.modal-overlay').forEach(overlay => {
        overlay.addEventListener('click', (e) => {
            if (e.target === overlay) {
                closeModal(overlay.id);
            }
        });
    });

    document.addEventListener('keydown', (e) => {
        if (e.key === 'Escape') {
            document.querySelectorAll('.modal-overlay').forEach(overlay => {
                if (overlay.classList.contains('active')) {
                    closeModal(overlay.id);
                }
            });
        }
    });
});