var currentRange = 1;                                                       //CURRENT RANGE IN THE PAGINATION
var numberOfEntries = 0;                                                    //TOTAL NUMBER OF LOGS
var totalPagination = 0;                                                    //TOTAL NUMBER OF PAGES NEEDED FOR PAGINATION
var pagination="";                                                          //WE WILL KEEP THE IDS OF THE PAGES WHICH WILL BE VISIBLE IN PAGINATION
var page = 0;                                                               //CURRENT PAGE NUMBER

function generatePagination(){
    totalPagination = Math.ceil(numberOfEntries/numberOfEntriesPerPage);    //SET THE LIMIT FOR PAGINATION
    for(var i=1;i<=totalPagination;i++){                                    //ADD ALL THE PAGES IN THE PAGINATION BAR
        $('<li id="nav'+i+'" class="page-item shadow"><a class="page-link" value='+i+' onclick="changeRange(this)">'+i+'</a></li>').insertBefore('.pagination li#next');
    }
    currentRange = Math.floor(page/paginationLimit);                        //GET THE CURRENT PAGINATION RANGE
    for(var i=0; i<paginationLimit;i++){
        pagination += "#nav"+(i+1)+",";                                     //FILTER THE FIRST <paginationLimit> PAGES FROM LIST
    }
    if(currentRange == 0)currentRange++;                                    //IF THE RANGE IS 0 INCREAMENT IT.
    $('.pagination li').not(pagination+'#next,#prev').hide();               //HIDE ALL THE PAGES FROM PAGINATION EXCEPT 1ST 1O, NEXT AND PREVIOUS
    if(totalPagination < (paginationLimit+1))
        $('.pagination li#next').addClass('disabled');

    $("#nav1 a").css({"background-color": "#337ab7","color": "#fff"});
}

/* THIS FUNCTION DISPLAYS THE LOGS PRESENT OF THE RESPECTIVE PAGES*/
function changeRange(scope){

    if(scope.getAttribute('value') == "next"){                              //CHECK IF NEXT WAS PRESSED
        if(currentRange*paginationLimit < totalPagination){                 //CHECK IF THE RANGE HAS NOT REACHED THE HIGHEST LIMIT
            $('.pagination li').not('#next,#prev').hide();                  //IF LIMIT NOT REACHED THEN HIDE ALL THE PAGES FROM PAGINATION 
            currentRange++;                                                 //INCREAMENT THE RANGE
            var nextlimit = (currentRange*paginationLimit)+1;               //GET THE NEXT RANGE LIMIT FOR PAGINATION
            for(var i = nextlimit-paginationLimit; i < nextlimit; i++)      //SHOW ALL THOSE PAGES IN PAGINATION
                $('#nav'+i).show();
            $('.pagination li#prev').removeClass('disabled');               //REMOVE THE DISABLED CLASS FROM THE PREVIOUS BUTTON
            if(currentRange*paginationLimit >= totalPagination)             //IF THE HIGHEST LIMIT HAS REACHED THEN DISABLE THE NEXT BUTTON
                $('.pagination li#next').addClass('disabled');
            if(paginationLimit == 1){                                            
                updateEntries(currentRange*numberOfEntriesPerPage);
            }
        }
    }
    else if(scope.getAttribute('value') == "prev"){                         //CHECK IF PREVIOUS WAS CLICKED
        if(currentRange > 1){                                               //CHECK IF THE RANGE HAS NOT REACHED THE LOWEST LIMIT
            $('.pagination li').not('#next,#prev').hide();                  //IF LIMIT NOT REACHED HIDE ALL THE PAGES FROM PAGINATION
            currentRange--;                                                 //DECREAMENT THE RANGE
            var nextlimit = (currentRange*paginationLimit)+1;               //GET THE PREVIOUS RANGE LIMIT FOR PAGINATION
            for(var i = nextlimit-paginationLimit; i < nextlimit; i++)      //SHOW ALL THOSE PAGES IN PAGINATION
                $('#nav'+i).show();
            $('.pagination li#next').removeClass('disabled');               //REMOVE THE DISABLED CLASS FROM THE PREVIOUS BUTTON
            if(currentRange == 1)                                           //IF THE LOWEST LIMIT HAS REACHED THEN DISABLE THE PREVIOUS BUTTON
                $('.pagination li#prev').addClass('disabled');
            if(paginationLimit == 1){                                          
                updateEntries(currentRange*numberOfEntriesPerPage);
            }
        }
    }
    else{                                                                   //ELSE THE PAGE HAS BEEN CLICKED                              
        page = scope.getAttribute('value');                                 //GET THE PAGE NUMBER CLICKED
        page = page - 1;
        $('.pagination>li>a').css({"color": "#337ab7","background-color": "#fff"});
        $(scope).css({"background-color": "#337ab7","color": "#fff"});
        updateEntries(page*numberOfEntriesPerPage);
    }
}