// Schedule Configuration JavaScript
// Handles visibility and interactions for LDAP sync configuration options

// Display options when Enable User Sync is toggled
let displayOptions = (delay) => {
    if (delay == null) delay = 500;
    if ($('#isSyncEnabled').is(':checked')) {
        $('#enableOptions').slideDown(delay);
    } else {
        $('#enableOptions').slideUp(delay);
        $('#syncGroupsEnable').prop('checked',false);
        $('#enableLockoutStatusSync').prop('checked', false);
        $('#enableDisableStatusSync').prop('checked', false);
        $('#enableDeleteSync').prop('checked',false);
        $('#enableDeleteOptions').slideUp(delay);
        $('#enableNestedGroupsOptions').slideUp(delay);
        $('#importNestedGroups').prop('checked', false);
    }
}

// Display delete options when Enable Delete User Sync is toggled
let displayDeleteOptions = (delay) => {
    if (delay == null) delay = 500;
    if ($('#enableDeleteSync').is(':checked')) {
        $('#enableDeleteOptions').slideDown(delay);
    } else {
        $('#enableDeleteOptions').slideUp(delay);
    }
}

// Display nested groups options when Enable User Group Membership Sync is toggled
let displayNestedGroupsOptions = (delay) => {
    if (delay == null) delay = 500;
    if ($('#syncGroupsEnable').is(':checked')) {
        $('#enableNestedGroupsOptions').slideDown(delay);
    } else {
        $('#enableNestedGroupsOptions').slideUp(delay);
        $('#importNestedGroups').prop('checked', false);
    }
}

// Form validation for sync interval
let validateSyncInterval = () => {
    var val = $('#syncInterval').val().trim();
    if (val === '' || val < 15 || val > 1380) {
        $('#error-message').removeClass('d-none');
        $('#syncInterval').addClass('is-invalid');
        return false;
    } else {
        $('#error-message').addClass('d-none');
        $('#syncInterval').removeClass('is-invalid');
        return true;
    }
}

// Bulk action for user selection
var allVals = [];

function bulkaction() {
    $("#bulkactionerror").html("");
    $('input:checkbox.usercheckbox').each(function() {
        if(this.checked) {
            removeItemAll(allVals, $(this).val());
            allVals.push($(this).val());
        }
        else {
            removeItemAll(allVals, $(this).val());
        }
    });
    $("#miniorangeUsersList").val(allVals.toString());
    if (allVals.length == 0) {
        $("#bulkactionerror").html("Select Users.");
        return;
    }
}

// Remove item from array
function removeItemAll(arr, value) {
    var i = 0;
    while (i < arr.length) {
        if (arr[i] === value) {
            arr.splice(i, 1);
        } else {
            ++i;
        }
    }
    return arr;
}

// Search functionality for users
function searchUsers(val, start) {
    $('#loading_image').show();
    if(val !== ''){
        var tableBody = "";
        var searchVal = [];
        currentRequest = jQuery.ajax({
            type : "POST",
            url : "showminiorangeusers",
            beforeSend : function() {
                if(currentRequest != null) {
                    currentRequest.abort();
                }
            },
            success : function(data) {
                if(start == 0) {
                    $('.pagination-wrapper').empty();
                }
                $('#example tbody').empty();
                var countUser = 0;
                numberOfEntries = Object.keys(data).length;
                var i = start;
                var j=0;

                $.each(data , function( key, value ) {
                    if(entryPresent(key,val)) {
                        j++;
                    }

                    if(countUser< numberOfEntries && countUser < start+5) {
                        if(entryPresent(key,val)) {
                            if(countUser>=start) {
                                if(allVals.includes(key)) {
                                    tableBody += "<tr><td><input class='usercheckbox' type='checkbox' value='"+key+"' checked  onChange='searchCheck()'> </td><td>"+key+"</td><td>"+value+"</td></tr>";
                                }
                                else {
                                    tableBody += "<tr><td><input class='usercheckbox' type='checkbox' value='"+key+"' onChange='searchCheck()' > </td><td>"+key+"</td><td>"+value+"</td></tr>";
                                }
                            }
                            countUser++;
                            i++;
                        }
                    }
                });

                if(start == 0 ) {
                    generatePaginationForSearch(j, val);
                }
                if(tableBody === "") {
                    $('.pagination-wrapper').empty();
                    $('.no-user-found').hide();
                    $('.no-record-found').show();
                }
                else {
                    $('.no-record-found').hide();
                    $('.no-user-found').hide();
                }
                $('#loading_image').hide();
                $('#example tbody').append(tableBody);
            }
        });
    }
    else{
        $('.pagination-wrapper').empty();
        generatePagination();
        $('#example tbody').empty();
        var tableBody = getTableBody(0);
        $('.no-record-found').hide();
        $('.no-user-found').hide();
        $("#example tbody").append(tableBody);
    }
}

// Check if entry is present in search
function entryPresent(usernameList, value){
    if(typeof usernameList === "undefined"){
        if(("undefined").includes(value))
            return true;
        return false;
    }

    if(usernameList.toLowerCase().includes(value.toLowerCase()) ) {
        return true;
    }
    return false;
}

// Search check functionality
function searchCheck() {
    $('input:checkbox.usercheckbox').each(function() {
        if(this.checked) {
            removeItemAll(allVals, $(this).val());
            allVals.push($(this).val());
        }
        else {
            removeItemAll(allVals, $(this).val());
        }
    });
}

// Pagination variables
var currentRange = 1;
var numberOfEntries = 0;
var totalPagination = 0;
var pagination = "";
var page = 0;
var usernameEmailListData, usernameEmailListJSON;
const paginationLimit = 5;
const numberOfEntriesPerPage = 5;
var order = "ASC";
var currentRequest = null;
var currentRequestForPagination = null;
var usersSelected = [];

// Update entries for pagination
function updateEntries(start){
    $('#example tbody').empty();
    getTableBody(start);
}

// Update entries for search
function updateEntriesForSearch(start, val){
    $('#example tbody').empty();
    searchUsers(val, start);
}

// Get table body content
function getTableBody(start){
    var tableBody = "";
    $("#miniorangeUsersList").val(allVals.toString());

    currentRequest = jQuery.ajax({
        type : "POST",
        url : "showminiorangeusers",
        beforeSend : function() {
            if(currentRequest != null) {
                currentRequest.abort();
            }
        },
        success : function(data) {
            numberOfEntries = Object.keys(data).length;
            var i = start;
            var j=0;

            if(numberOfEntries == 0) {
                $('.no-user-found').show();
            }
            else {
                $.each(data , function( key, value ) {
                    if(j>=i && i<start+numberOfEntriesPerPage && i<numberOfEntries) {
                        if(allVals.includes(key)) {
                            tableBody += "<tr><td><input class='usercheckbox' type='checkbox' value='"+key+"' checked onChange='searchCheck()'> </td><td>"+key+"</td><td>"+value+"</td></tr>"
                        }
                        else {
                            tableBody += "<tr><td><input class='usercheckbox' type='checkbox' value='"+key+"' > </td><td>"+key+"</td><td>"+value+"</td></tr>"
                        }
                        i++;
                    }
                    j++;
                });
            }
            $('#example tbody').append(tableBody);
            $('#loading_image').hide();
        },
        error : function(data) {
            $('#loading_image').hide();
            $('.pagination-wrapper').empty();
            $('.no-user-found').hide();
            $('.no-record-found').show();
        }
    });
}

// Generate pagination
function generatePagination(){
    currentRequestForPagination = jQuery.ajax({
        type : "POST",
        url : "showminiorangeusers",
        beforeSend : function() {
            if(currentRequestForPagination != null) {
                currentRequestForPagination.abort();
            }
        },
        success : function(data) {
            numberOfEntries = Object.keys(data).length;

            $("#pagination-wrapper").append(
                '<ul class="pagination position left-side">' +
                    '<li name ="myPrev" id="prev" class="disabled page-item shadow"><a class="page-link" value="prev" onclick="changeRange(this,0)">&laquo;</a></li>' +
                    ' <li name="myNext" id="next" class="next page-item shadow"><a class="page-link" value="next" onclick="changeRange(this,0)">&raquo;</a></li>' +
                    '</ul>'
            );

            totalPagination = Math.ceil(numberOfEntries/numberOfEntriesPerPage);
            for(var i=1;i<=totalPagination;i++){
                $('<li id="nav'+i+'" class="page-item shadow"><a class="page-link" value='+i+' onclick="changeRange(this,0)">'+i+'</a></li>').insertBefore('.pagination li#next');
            }
            currentRange = Math.floor(page/paginationLimit);
            for(var i=0; i<paginationLimit;i++){
                pagination += "#nav"+(i+1)+",";
            }
            if(currentRange == 0)currentRange++;
            $('.pagination li').not(pagination+'#next,#prev').hide();
            if(totalPagination < (paginationLimit+1))
                $('.pagination li#next').addClass('disabled');

            $("#nav1 a").css({"background-color": "#337ab7","color": "#fff"});
        }
    });
}

// Generate pagination for search
function generatePaginationForSearch(searchVal, val){
    $("#pagination-wrapper").append(
        '<ul class="pagination position left-side">' +
        '<li name ="myPrev" id="prev" class="disabled page-item shadow"><a class="page-link" value="prev" onclick="changeRange(this,\''+val+'\')">&laquo;</a></li>' +
        ' <li name="myNext" id="next" class="next page-item shadow"><a class="page-link" value="next" onclick="changeRange(this,\''+val+'\')">&raquo;</a></li>' +
        '</ul>'
    );

    totalPagination = Math.ceil(searchVal/numberOfEntriesPerPage);
    for(var i=1;i<=totalPagination;i++){
        $('<li id="nav'+i+'" class="page-item shadow"><a class="page-link" value='+i+' onclick="changeRange(this,\''+val+'\')">'+i+'</a></li>').insertBefore('.pagination li#next');
    }

    currentRange = Math.floor(page/paginationLimit);
    for(var i=0; i<paginationLimit;i++){
        pagination += "#nav"+(i+1)+",";
    }
    if(currentRange == 0)currentRange++;
    $('.pagination li').not(pagination+'#next,#prev').hide();
    if(totalPagination < (paginationLimit+1))
        $('.pagination li#next').addClass('disabled');

    $("#nav1 a").css({"background-color": "#337ab7","color": "#fff"});
}

// Change range for pagination
function changeRange(scope, search){
    $('#loading_image').show();
    if(scope.getAttribute('value') == "next"){
        if(currentRange*paginationLimit < totalPagination){
            $('.pagination li').not('#next,#prev').hide();
            currentRange++;
            var nextlimit = (currentRange*paginationLimit)+1;
            for(var i = nextlimit-paginationLimit; i < nextlimit; i++)
                $('#nav'+i).show();
            $('.pagination li#prev').removeClass('disabled');
            if(currentRange*paginationLimit >= totalPagination)
                $('.pagination li#next').addClass('disabled');
            if(paginationLimit == 1){
                updateEntries(currentRange*numberOfEntriesPerPage);
            }
        }
    }
    else if(scope.getAttribute('value') == "prev"){
        if(currentRange > 1){
            $('.pagination li').not('#next,#prev').hide();
            currentRange--;
            var nextlimit = (currentRange*paginationLimit)+1;
            for(var i = nextlimit-paginationLimit; i < nextlimit; i++)
                $('#nav'+i).show();
            $('.pagination li#next').removeClass('disabled');
            if(currentRange == 1)
                $('.pagination li#prev').addClass('disabled');
            if(paginationLimit == 1){
                updateEntries(currentRange*numberOfEntriesPerPage);
            }
        }
    }
    else{
        page = scope.getAttribute('value');
        page = page - 1;
        $('.pagination>li>a').css({"color": "#337ab7","background-color": "#fff"});
        $(scope).css({"background-color": "#337ab7","color": "#fff"});
        $("#bulkactionerror").html("");

        $('input:checkbox.usercheckbox').each(function() {
            if(allVals.includes(this.value)) {
                this.checked = true;
            }
        });
        $('input:checkbox.usercheckbox').each(function() {
            if(this.checked) {
                removeItemAll(allVals, $(this).val());
                allVals.push($(this).val());
            }
            else {
                removeItemAll(allVals, $(this).val());
            }
        });
        if(search==0) {
            updateEntries(page*numberOfEntriesPerPage);
        }
        else {
            updateEntriesForSearch(page*numberOfEntriesPerPage,search);
        }
    }
}

// Document ready function
$(document).ready(function(){
    // Form validation
    $('#configureschedules').on('submit', function(event) {
        if (!validateSyncInterval()) {
            event.preventDefault();
        }
    });

    // Tab functionality
    $('button[data-bs-toggle="tab"]').on('shown.bs.tab', function (e) {
        localStorage.setItem('lastTab', $(this).attr('href'));
    });

    var lastTab = localStorage.getItem('lastTab');
    console.log(lastTab)
    if (lastTab == "#scheduleTypeTab") {
        $('#configure-schedule-tab').removeClass('active');
        $('#configure-schedule').removeClass('active');
        $('[href="' + lastTab + '"]').addClass('active');
        $('#schedule-type').addClass('active');
    }
    else {
        $('#schedule-type-tab').removeClass('active');
        $('#schedule-type').removeClass('active');
        $('[href="' + lastTab + '"]').addClass('active');
        $('#configure-schedule').addClass('active');
    }

    // Initialize user data
    usernameEmailListData = $('#usernameEmailList').val();
    usernameEmailListJSON = JSON.parse(usernameEmailListData);
    for(i=0;i<usernameEmailListJSON.length;i++) {
        allVals.push(usernameEmailListJSON[i]);
    }
    order = "DESC";

    // User selection functionality
    if (sessionStorage.getItem("usersSelected") != null) {
        usersSelected = sessionStorage.getItem("usersSelected");
        usersSelected = JSON.parse(usersSelected);
        $('.usercheckbox').each(function(index, html) {
            if (usersSelected.indexOf(html.value) > -1) {
                this.checked = true;
            }
        });
    }

    // Select all functionality
    $("#select_all").click(function() {
        if ($("#select_all").is(':checked'))
            $('.usercheckbox').prop('checked',true);
        else
            $('.usercheckbox').prop('checked',false);
    });

    // Individual checkbox functionality
    $(".usercheckbox").click(function() {
        var isallselected = true;
        $('.usercheckbox').each(function() {
            if (!this.checked) {
                isallselected = false;
                return false;
            }
        });
        if (isallselected) {
            $('#select_all').prop('checked', true);
        }
    });

    // User checkbox change functionality
    $('.usercheckbox').change(function() {
        if (!$(this).is(":checked")) {
            $("#select_all").attr("checked", false);
            removeValueFromSession($(this).val());
        } else {
            if (this.checked)
                addValueInSession($(this).val());
        }
    });

    // Select all change functionality
    $('#select_all').change(function() {
        if (!$(this).is(":checked")) {
            $('.usercheckbox').each(function(index,html) {
                removeValueFromSession(html.value);
                removeItemAll(allVals, $(this).val())
            });
        } else {
            $('.usercheckbox').each(function(index,html) {
                if (usersSelected.indexOf(html.value) == -1)
                    addValueInSession(html.value);
            });
        }
    });

    // Fetch selected user functionality
    $("#fetchSelectedUser").click(()=>{
        $('#loading_image').show();
        $('#example tbody').empty();
        var tableBody = getTableBody(0);
        $("#example tbody").append(tableBody);
        $("#pagination-wrapper").empty();
        generatePagination();
    });

    // Add value to session
    function addValueInSession(value) {
        if (sessionStorage.getItem("usersSelected") != null) {
            usersSelected = sessionStorage.getItem("usersSelected");
            usersSelected = JSON.parse(usersSelected);
            usersSelected.push(value);
            sessionStorage.setItem("usersSelected", JSON.stringify(usersSelected));
        } else {
            usersSelected.push(value);
            sessionStorage.setItem("usersSelected", JSON.stringify(usersSelected));
        }
    }

    // Remove value from session
    function removeValueFromSession(value) {
        if (sessionStorage.getItem("usersSelected") != null) {
            usersSelected = sessionStorage.getItem("usersSelected");
            usersSelected = JSON.parse(usersSelected);
            if (usersSelected.indexOf(value) > -1) {
                usersSelected.remove(value);
                sessionStorage.setItem("usersSelected", JSON.stringify(usersSelected));
            }
        }
    }

    // Array remove method
    Array.prototype.remove = function(elem) {
        var match = -1;
        while ((match = this.indexOf(elem)) > -1) {
            this.splice(match, 1);
        }
    };
}); 