var gatewaylogsData,gatewayLogsJSON;
const paginationLimit = 5;                                                  //PAGE NUMBERS PER PAGINATION
const numberOfEntriesPerPage = 10;
var order = "ASC";                                                          //THE LOGS WILL BE SORTED IN ASCENDING ORDER IN START
var username_case_sensitive_search = false;
var action_case_sensitive_search = false;

$(document).ready(function(){
    gatewaylogsData = $('#gatewaylogs').val();                              //GET THE LOGS(JSON DATA IN STRING FORMAT)
    gatewaylogsJSON = JSON.parse(gatewaylogsData);                          //CONVERT THE LOGS IN JSON FORMAT
    gatewaylogsJSON.sort(function(a, b){                                    //SORT THE LOGS BASED ON TIMESTAMP
        return compareStrings(a.timestamp, b.timestamp);
    });

    order = "DESC";
    numberOfEntries = gatewaylogsJSON.length;                               //SET THE TOTAL NUMBER OF LOGS
    var tableBody = getTableBody(0);                                        //ADD THE FIRST 10 LOGS
    $("#example tbody").append(tableBody);                                  //APPEND IT IN TBODY

    generatePagination();
});

function compareStrings(a,b){
    if(typeof a === "undefined"){
        if( typeof b === "undefined")
            return 0;
        else
            return 1;
    }
    else if(typeof b === "undefined")
        return -1;

    a = a.toLowerCase();
    b = b.toLowerCase();

    if(order === "ASC")
        return (a < b) ? -1 : (a > b) ? 1 : 0;
    else
        return (a > b) ? -1 : (a < b) ? 1 : 0;
}

function updateEntries(start){
    $('#example tbody').empty();                                        //EMPTY THE TABLE BODY
    var tableBody = getTableBody(start);                                //GET THE TABLE BODY WITH THE RESPECTIVE LOGS
    $('#example tbody').append(tableBody);                              //APPEND THEM IN TABLE BODY
}

//THIS FUNCTION RETURNS THE TABLE BODY WITH THE NEXT 10 LOGS
function getTableBody(start){
    var tableBody="";
    for(var i=start;i<start+numberOfEntriesPerPage && i<numberOfEntries;i++){
        tableBody += "<tr><td>"+gatewaylogsJSON[i].ipAddress+"</td><td>"+gatewaylogsJSON[i].username+"</td><td>"+gatewaylogsJSON[i].timestamp+"</td><td>"+gatewaylogsJSON[i].action+"</td></tr>";
    }
    return tableBody;
}

function searchLogs(value){
    if(value !== ''){
        $('#example tbody').empty();
        $('.pagination-wrapper').hide();
        var tableBody = "";
        for(var i=0;i<numberOfEntries;i++){
            if(entryPresent(gatewaylogsJSON[i],value))
                tableBody += "<tr><td>"+gatewaylogsJSON[i].ipAddress+"</td><td>"+gatewaylogsJSON[i].username+"</td><td>"+gatewaylogsJSON[i].timestamp+"</td><td>"+gatewaylogsJSON[i].action+"</td></tr>";
        }
        if(tableBody === "")
            $('.no-record-found').show();
        else
            $('.no-record-found').hide();
        $('#example tbody').append(tableBody);
    }
    else{
        $('.pagination-wrapper').show();
        $('#example tbody').empty();
        var tableBody = getTableBody(0);                                        //ADD THE FIRST 10 LOGS
        $("#example tbody").append(tableBody);                                  //APPEND IT IN TBODY
        if(tableBody === "")
            $('.no-record-found').show();
        else
            $('.no-record-found').hide();
    }
}

function changeOrder(){
    if(order === "ASC"){
        gatewaylogsJSON.sort(function(a, b){
            return compareStrings(a.timestamp, b.timestamp);
        });
        order = "DESC";
        updateEntries(page*numberOfEntriesPerPage);
    }
    else if(order === "DESC"){
        gatewaylogsJSON.sort(function(a, b){
            return compareStrings(a.timestamp, b.timestamp);
        });
        order = "ASC";
        updateEntries(page*numberOfEntriesPerPage);
    }
}

function entryPresent(gatewayLogs,value){
    if(typeof gatewayLogs.username === "undefined" || typeof gatewayLogs.ipAddress === "undefined" || typeof gatewayLogs.action === "undefined" || typeof gatewayLogs.timestamp === "undefined"){
        if(("undefined").includes(value))
            return true;
        return false;
    }
    //if((NOT CASE SENSITIVE AND ENTRY PRESENT AS ENTERED) OR (CASE SENSITIVE AND ENTRY PRESENT IN ANY CASE))
    if((!username_case_sensitive_search && gatewayLogs.username.toLowerCase().includes(value.toLowerCase())) || (username_case_sensitive_search && gatewayLogs.username.includes(value)) || gatewayLogs.ipAddress.includes(value) || gatewayLogs.timestamp.includes(value) || (!action_case_sensitive_search && gatewayLogs.action.toLowerCase().includes(value.toLowerCase())) || (action_case_sensitive_search && gatewayLogs.action.includes(value)))
        return true;
    return false;
}