<%@ page import="java.util.Objects" %>
<%@ page import="com.miniorangegateway.util.PropertiesRegistry" %>
<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib prefix="s" uri="/struts-tags"%>

<datalist id="ldap-attrs">
	<option value="displayName">
	<option value="firstName">
	<option value="givenName">
	<option value="mail">
	<option value="mobile">
	<option value="memberOf">
	<option value="objectGUID">
	<option value="objectSid">
	<option value="sAMAccountName">
	<option value="sn">
	<option value="telephoneNumber">
	<option value="userPrincipalName">
</datalist>

<div class="login-group test-config pt-3">
	<div class="row">
		<div class="col-md-3">
			<p class="input_field_fonts">Configuration Identifier<span style="color:red">*</span>
				<a data-bs-toggle="tooltip" title="Enter your LDAP name like AD, OpenLDAP etc. Only alphabets, digits and underscore are allowed in the name.">
					<i class="fas fa-info-circle"></i>
				</a>
			</p>
		</div>
		<div class="col-md-5">
			<s:textfield name="identifier" id="ldapidentifier" placeholder="LDAP Name"
						 title="Only alphabets, digits and underscore are allowed." pattern="^\w{1,20}$" cssClass="form-control" autofocus="true" required="true" value="%{configuration.identifier}" />
		</div>
	</div>
	<br/>
	<div class="row">
		<div class="col-md-3">
			<p class="input_field_fonts">LDAP Server URL<span style="color:red">*</span>
				<a data-bs-toggle="tooltip" title="Connection string for the LDAP Server. eg: ldap://domain.com:port">
					<i class="fas fa-info-circle"></i>
				</a>
			</p>
		</div>
		<div class="col-md-5">
			<s:textfield name="serverUrl" id="serverUrl" cssClass="form-control"
						 required="true" value="%{configuration.ldapServer}" placeholder="LDAP Server Url Eg: ldap://127.0.0.1" title="miniOrange LDAP gateway URL"/>
		</div>
	</div>
	<br/>
	 <div class='row'>
                <div class="col-md-3">
                </div>
                <div class="col-md-2" style="margin-top: 5px;">
                    <input type="submit" id="test_ldap_connection_button" name="test_ldap_connection_button" onclick="testLDAPServerBindAccountCreds('test_connection_button')"
                           class="btn btn-primary" value="Test connection">
                </div>
     </div><br>
	<div class="row">
		<div class="col-md-3">
			<p class="input_field_fonts">Bind Account DN<span style="color:red">*</span>
				<a data-bs-toggle="tooltip" title="LDAP service account distinguished name. e.g. CN=service,DC=domain,DC=com">
					<i class="fas fa-info-circle"></i>
				</a>
			</p>
		</div>
		<div class="col-md-5">
			<s:textfield name="bindAccountDN" id="bindAccountDN" cssClass="form-control" placeholder="Bind Account Distinguished Name(DN)"
						 title="Bind Account DN" required="true"  value="%{configuration.bindAccountDN}"  />
		</div>
	</div>
	<br/>
	<div class="row">
		<div class="col-md-3">
			<p class="input_field_fonts">Bind Account Password<span style="color:red">*</span>
				<a data-bs-toggle="tooltip" title="LDAP service account password">
					<i class="fas fa-info-circle"></i>
				</a>
			</p>
		</div>
		<div class="col-md-5">
			<s:password name="bindAccountPassword" id="bindAccountPassword" cssClass="form-control"
						placeholder="Bind Account Password" title="Bind Account Password"
						required="true" showPassword="true" value="%{configuration.bindAccountPassword}"/><br>
                                        <input type="submit" id="test_bind_account_button" name="test_bind_account_button" onclick="testLDAPServerBindAccountCreds('test_bind_account_button')"
                                               class="btn btn-primary" value="Test Bind Account Credentials">
		</div>
	</div>
	<br/>
	<div class="row">
		<div class="col-md-3">
			<p class="input_field_fonts">Search Bases<span style="color:red">*</span>
				<a data-bs-toggle="tooltip" title="Define where users logging in will be located in the LDAP Environment. For multiple searchBase use semicolon(;) separated values.">
					<i class="fas fa-info-circle"></i>
				</a>
			</p>
		</div>
		<div class="col-md-5">
			<s:textfield name="searchBase" id="searchBase" cssClass="form-control" placeholder="eg. cn=Users,dc=miniorange,dc=com" title="Search Base" required="true" value="%{configuration.searchBase}"/>
		</div>
	</div>
	<br/>
		<div class="row" id="searchFilterDiv">
                <div class="col-md-3 input_field_fonts">
                    <a data-toggle="tooltip" data-placement="top" style="color: inherit; text-decoration: none;" title="" data-original-title="It is a basic LDAP Query for searching users based on mapping of username to a particular LDAP attribute. eg: (&(objectClass=*)(cn=?))">
                        <p class="input_field_fonts">Search Filter<span style="color:red">*</span> &nbsp;<i
                                class="glyphicon glyphicon-info-sign pull-right"></i></p>
                    </a>
                </div>
                <div class="col-md-5">
                    <s:select id="ldapSearchFilter" list="ldapSearchFilterMap" name="setSearchFilter" class="form-control select2"
                              onchange="changeSearchFilter()"/>
                </div>
        </div>
        <div class="row bottom-buffer" id="customSearchFilterDiv">
                <div class="col-md-3"></div>
                <div class="col-md-5">
                    <s:textfield name="searchFilter" id="ldapCustomSearchFilter" cssClass="form-control" required="true"
                                 placeholder="Write Custom Filter" title="Must contain Question Mark(?) for attributes you want to match e.g. (&(objectClass=*)(uid=?))" pattern=".*\?.*"
                                 onchange="initSearchFilterSelect()" value="%{configuration.ldapSearchFilter}" />
                </div>
        </div>
	<br/>
	<div class="row">
		<div class="col-md-3">
			<p class="input_field_fonts"><span id="domainNameLabel">Domain Name</span>
				<a data-bs-toggle="tooltip" title="This LDAP configuration will be used to authenticate the users with domain name entered here. NOTE: This works only if users sign in using there email.">
					<i class="fas fa-info-circle"></i>
				</a>
			</p>
		</div>
		<div class="col-md-5">
			<s:textfield name="domainName" id="domainName" cssClass="form-control" placeholder="Semi-colon separated list of domain. Eg. miniorange.com" value="%{configuration.domainName}" />
		</div>
	</div>
	<br/>
	<div class="row">
		<div class="col-md-3">
			<p class="input_field_fonts"><span id="firstNameAttributeLabel">First Name Attribute<span style="color:red">*</span></span>
				<a data-bs-toggle="tooltip" title="This is the first name attribute name in LDAP.">
					<i class="fas fa-info-circle"></i>
				</a>
			</p>
		</div>
		<div class="col-md-5">
			<s:textfield name="firstNameAttribute" id="firstNameAttribute" list="ldap-attrs" cssClass="form-control" placeholder="First Name Attribute . Eg. givenName" value="%{configuration.firstNameAttribute}" required="true"/>
		</div>
	</div>
	<br>
	<div class="row">
		<div class="col-md-3">
			<p class="input_field_fonts"><span id="lastNameAttributeLabel">Last Name Attribute<span style="color:red">*</span></span>
				<a data-bs-toggle="tooltip" title="This is the last name attribute name in LDAP.">
					<i class="fas fa-info-circle"></i>
				</a>
			</p>
		</div>
		<div class="col-md-5">
			<s:textfield name="lastNameAttribute" id="lastNameAttribute" list="ldap-attrs" cssClass="form-control" placeholder="Last Name Attribute . Eg. sn" value="%{configuration.lastNameAttribute}" required="true"/>
		</div>
	</div>
	<br>
	<div class="row">
		<div class="col-md-3">
			<p class="input_field_fonts"><span id="emailAttributeLabel">Email Attribute<span style="color:red">*</span></span>
				<a data-bs-toggle="tooltip" title="This is the email attribute name in LDAP.">
					<i class="fas fa-info-circle"></i>
				</a>
			</p>
		</div>
		<div class="col-md-5">
			<s:textfield name="emailAttribute" id="emailAttribute" list="ldap-attrs" cssClass="form-control" placeholder="Email Attribute. Eg. mail" value="%{configuration.emailAttribute}" required="true"/>
		</div>
	</div>
	<br>
	<div class="row">
		<div class="col-md-3">
			<p class="input_field_fonts"><span id="usernameAttributeLabel">Username Attribute<span style="color:red">*</span></span>
				<a data-bs-toggle="tooltip" title="This is the username attribute name in LDAP.">
					<i class="fas fa-info-circle"></i>
				</a>
			</p>
		</div>
		<div class="col-md-5">
			<s:textfield name="usernameAttribute" id="usernameAttribute" list="ldap-attrs" cssClass="form-control" placeholder="Username Attribute. Eg. samaccountname" value="%{configuration.usernameAttribute}" required="true"/>
		</div>
	</div>
	<br>
	<div class="row">
		<div class="col-md-3">
			<p class="input_field_fonts"><span id="phoneAttributeLabel">Phone Attribute</span>
				<a data-bs-toggle="tooltip" title="This is the phone number attribute name in LDAP.">
					<i class="fas fa-info-circle"></i>
				</a>
			</p>
		</div>
		<div class="col-md-5">
			<s:textfield name="phoneAttribute" id="phoneAttribute" list="ldap-attrs" cssClass="form-control" placeholder="Phone Attribute. Eg. telephonenumber" value="%{configuration.phoneAttribute}"/>
		</div>
	</div>
	<br>
		<div class="row">
			<div class="col-md-3">
				<p class="input_field_fonts"><span id="groupAttributeLabel">User Group Attribute</span>
					<a data-bs-toggle="tooltip"
					   title="This is the group membership attribute name in LDAP. Eg: memberof">
						<i class="fas fa-info-circle"></i>
					</a>
				</p>
			</div>
			<div class="col-md-5">
				<s:textfield name="groupAttribute" id="groupAttribute" list="ldap-attrs" cssClass="form-control" placeholder="Group Attribute. Eg. memberof" value="%{configuration.groupAttribute}"/>
			</div>
		</div>
		<br>
	<div class="row">
		<div class="col-md-3">
			<p class="input_field_fonts">Search Bases for Groups
				<a data-bs-toggle="tooltip"
				   title="Define where groups will be located in the LDAP Environment. For multiple searchBase use semicolon(;) separated values.">
					<i class="fas fa-info-circle"></i>
				</a>
			</p>
		</div>
		<div class="col-md-5">
			<s:textfield name="searchBaseForGroups" id="searchBaseForGroups" cssClass="form-control"
						 placeholder="eg. cn=Users,dc=miniorange,dc=com" title="Search Base For Groups"
						 value="%{configuration.searchBaseForGroups}"/>
		</div>
	</div>
	<br/>
	<div class="row">
		<div class="col-md-3">
			<p class="input_field_fonts">Group Name Attribute
				<a data-bs-toggle="tooltip" title="Specifies the attribute name for group name in LDAP">
					<i class="fas fa-info-circle"></i>
				</a>
			</p>
		</div>
		<div class="col-md-5">
			<s:textfield name="groupNameAttribute" id="groupNameAttribute" cssClass="form-control"
                         placeholder="eg. samaccountname" title="Group Name Attribute"
						 value="%{configuration.groupNameAttribute}"/>
		</div>
	</div>
	<br/>
	<div class="row">
		<div class="col-md-3">
			<p class="input_field_fonts"><span id="ldapAttributesLabel">LDAP Attribute List</span>
				<a data-bs-toggle="tooltip" title="This LDAP configuration will be used to fetch the attributes from LDAP. NOTE: Only the attributes mentioned here will fetched from LDAP.">
					<i class="fas fa-info-circle"></i>
				</a>
			</p>
		</div>
		<div class="col-md-5">
			<s:textfield name="ldapAttributes" value="%{configuration.ldapAttributes}" id="ldapAttributes" cssClass="form-control" placeholder="Semi-colon separated list of attributes. Eg. cn;mail;givenName" />
		</div>
	</div>
	<br>
	<div class="row">
		<div class="col-md-3">
			<p class="input_field_fonts">Idp User Profile Fields Mapping
				<a data-bs-toggle="tooltip" title="Idp User Profile Fields which will be used during sync">
					<i class="fas fa-info-circle"></i>
				</a>
			</p>
		</div>
		<div class="col-md-9">
			<button id="add_user_profile_field" type="button" class="btn btn-primary">
				<i class="fas fa-plus"></i> Add Attribute Mapping
			</button>
		</div>
	</div>
	<br>
	<div class="row mb-2">
		<div class="col-md-3"></div>
		<div class="col-md-5" id="userProfileFields">
			<s:if test="idpUserProfileFieldsMap.size > 0">
				<s:iterator value="idpUserProfileFieldsMap" var="userField">
					<div class="row user-profile-field">
						<div class="col-md-6">
							<s:select list="idpUserProfileFieldsNameList"  name="idpUserProfileFieldNames[]"
									  cssClass="form-select"
									  required="true" value="%{#userField.key}"/>
						</div>
						<div class="col-md-5">
							<input type="text"
								   name="idpUserProfileFieldValues[]" list="ldap-attrs"
								   class="form-control" value="<s:property value="%{#userField.value}" />"
								   placeholder="User Profile Field Value">
						</div>
						<div class="col-md-1">
							<button type="button" onclick="delUserProfile(this)"
									class="btn btn-danger"
									title="Delete User Profile Field">
								<i class="fas fa-times"></i>
							</button>
						</div>
					</div>
				</s:iterator>
			</s:if>
		</div>
	</div>
	<div class="row">
		<div class="col-md-3">
			<p class="input_field_fonts">Enable Configuration for Sync :
				<a data-bs-toggle="tooltip" title="Whether or not to enable this configuration for sync.">
					<i class="fas fa-info-circle"></i>
				</a>
			</p>
		</div>
		<div class="col-md-3">
			<label class="switch">
				<s:checkbox id="addToScheduler"
							name="addToScheduler"
							value="%{configuration.addToScheduler}"
				/>
				<div class="slider round"></div>
			</label>
		</div>
	</div>
	<br>
	<div class="row">
		<div class="col-md-5 col-md-offset-3">
			<input type="submit" value="Save"
				   class="btn orange-btn col-md-2 margin-right" />
		</div>
	</div>
	<br> <br>
</div>

<script>
	    let maxAttributes = "<s:property value='maxAttributes' />"
        let searchFilterSelect;
        let searchFilter;
        $(document).ready(() => {
            searchFilterSelect = $('#ldapSearchFilter');
            searchFilter = $('#ldapCustomSearchFilter');
            searchFilter.val() && initSearchFilterSelect();
            searchFilter.val() || changeSearchFilter();
            $(".select2").select2();
            searchFilterSelect.one('select2:open', () => $('input.select2-search__field').prop('placeholder', 'Select a Search Filter'));
        });

		let options = generateCustomAttributes(maxAttributes);
	$('#add_user_profile_field').on('click', () => {
		let userProfileMapping = `
	<div class="row user-profile-field">
		<div class="col-md-6">
			<select name="idpUserProfileFieldNames[]" class="form-select idpUserProfileFieldNames" required="required">
				<option value="">Select User Profile Field</option>
				<option value="alternateEmail">Alternate Email</option>
			</select>
		</div>
		<div class="col-md-5">
			<input type="text" name="idpUserProfileFieldValues[]" class="form-control" list="ldap-attrs"
				placeholder="User Profile Field Value">
		</div>
		<div class="col-md-1">
			<button type="button" onclick="delUserProfile(this)" class="btn btn-danger"
					title="Delete User Profile Field"><i class="fas fa-times"></i></i>
			</button>
		</div>
	</div>
		`;
		$('#userProfileFields').append(userProfileMapping);
		$('.idpUserProfileFieldNames').append(options);
	});
	function delUserProfile(el) {
		$(el).parents(".user-profile-field").remove();
	}

    const changeSearchFilter = () => {
            let current = $('#ldapSearchFilter option:selected');
            current.val() !== 'custom' && searchFilter.val(current.val());
        }
        const initSearchFilterSelect = () => {
            searchFilter.val(searchFilter.val().replace(/\s*([()])\s*/g, "$1"));
            for (const e of $('#ldapSearchFilter option')) {
                if (searchFilter.val() === e.value) {
                    searchFilterSelect.val(e.value).change();
                    return;
                }
            }
            searchFilterSelect.val($('#ldapSearchFilter option:last').val()).change();
        }
		function testLDAPServerBindAccountCreds(button_clicked) {
				$('#saveldapconfig').attr('action', 'testldapbindaccount');
				$('#saveldapconfig').attr('novalidate', 'true');
				$('#updateldapconfig').attr('action', 'testldapbindaccount');
				$('#updateldapconfig').attr('novalidate', 'true');
		}
		function generateCustomAttributes(maxAttributes) {
			let options = '';
			for (let i = 1; i <= maxAttributes; i++) {
				options += '<option value="customAttribute' + i + '">Custom Attribute ' + i + '</option>';
			}
			return options;
		}
</script>
