<%@ taglib prefix="s" uri="/struts-tags" %>
<div class="col-md-3 ldap-sidebar">
    <div class="ldap-sidebar-header">
        <i class="bi bi-list-ul me-2"></i>LDAP Configurations
    </div>

    <!-- Search Box -->
    <div class="sidebar-search">
        <input type="text" id="identifierSearch" placeholder="Search configurations..." class="form-control-sm">
    </div>

    <ul class="ldap-identifier-list">
        <s:if test="ldapIdentifiers != null && !ldapIdentifiers.isEmpty()">
            <s:iterator value="ldapIdentifiers" var="identifier">
                <li class="ldap-identifier-item">
                    <a href="show-change-history?ldapIdentifier=<s:property value="#identifier" escapeHtml='true'/>"
                       class="ldap-identifier-link <s:if test='#identifier == forLdapIdentifier'>active</s:if>">
                        <div class="identifier-name">
                            <s:property value="#identifier"/>
                        </div>
                        <s:if test="identifierChangeCounts != null && identifierChangeCounts.containsKey(#identifier)">
                            <div class="identifier-meta">
                                <s:property value="identifierChangeCounts.get(#identifier)"/> changes
                                <span class="identifier-badge">
                                    <i class="bi bi-clock-history"></i>
                                </span>
                            </div>
                        </s:if>
                        <s:else>
                            <div class="identifier-meta"></div>
                        </s:else>
                    </a>
                </li>
            </s:iterator>
        </s:if>
        <s:else>
            <li class="ldap-identifier-item">
                <div class="ldap-identifier-link" style="color: #6c757d; font-style: italic;">
                    No active identifiers
                </div>
            </li>
        </s:else>

        <s:if test="deletedIdentifierMap != null && !deletedIdentifierMap.isEmpty()">
            <li class="ldap-sidebar-header" style="background:#fef2f2; color:#b91c1c; border-top:1px solid #f5c2c7;">
                <i class="bi bi-trash me-2"></i> Deleted Identifiers
            </li>

            <s:iterator value="deletedIdentifierMap.entrySet()" var="entry">
                <li class="ldap-identifier-item deleted-item">
                    <a href="show-change-history?ldapIdentifier=<s:property value="#entry.key" escapeHtml='true'/>"
                       class="ldap-identifier-link <s:if test='#entry.key == forLdapIdentifier'>active</s:if> deleted-link">
                        <div class="identifier-name">
                            <s:set var="cleanKey" value="%{#entry.key.split(':+')[0]}"/>
                            <s:property value="#cleanKey"/>
                            <s:if test="#entry.key.contains('DELETED')">
                                <span class="deleted-tag">(Deleted)</span>
                            </s:if>
                        </div>
                        <div class="identifier-meta">
                            <s:property value="#entry.value.size()"/> changes (before deletion)
                            <span class="identifier-badge deleted-badge">
                                <i class="bi bi-exclamation-triangle"></i>
                            </span>
                        </div>
                    </a>
                </li>
            </s:iterator>
        </s:if>
    </ul>
</div>


