<%@ taglib prefix="s" uri="/struts-tags" %>
<!DOCTYPE html>
<html>
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate" />
        <meta http-equiv="Pragma" content="no-cache" />
        <meta http-equiv="Expires" content="0" />
        <link rel="shortcut icon" href="images/favicon.png">
        <title>LDAP Configurations</title>
        <link rel="stylesheet" href="css/style.css" />
        <link rel="stylesheet" href="css/bootstrap/bootstrap5-0-2.min.css">
        <link rel="stylesheet" href="css/admin_style.css">
        <link rel="stylesheet" href="css/jquery.dataTables.min.css">
        <link rel="stylesheet" href="css/normalise.css">
        <link rel="stylesheet" href="css/jquery.dataTables.min.css">
        <link rel="stylesheet" href="css/bootstrap/dataTables.bootstrap.css">
        <script src="js/jquery-3.5.1.min.js"></script>
        <script src="js/ldapconfigpagination.js"></script>
        <script src="js/pagination.js"></script>
    </head>
    <body class="white">
        <div id="loading_image" class="collapse">
            <div class="loadingbar"></div>
        </div>
        <jsp:include page="header.jsp" />
        <div class="row me-2">
            <div class="col-md-2">
                <s:include value="menu.jsp">
                    <s:param name="currentmenu" value="2" />
                </s:include>
            </div>
            <div class="col-md-10 mt-4">
                <div class="container-fluid" id="actionMessages">
                    <s:include value="actionmessages.jsp"/>
                </div>

                 <!-- Modal -->
                 <div class="modal" role="dialog" id="testLDAPConfiguration" tabindex="-1" aria-labelledby="myModalLabel" aria-hidden="true" >
                    <div class="modal-dialog widthcontrol">
                       <div class="modal-content widthcontrol">
                          <div class="modal-header">
                             <h5 class="modal-title">Test LDAP Configuration</h5>
                             <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                          </div>
                          <form action="testldapconfiguration" autocomplete="off" method="post">
                             <s:hidden name="testIdentifier" id="ldapTestIdentifier"/>
                             <s:token />
                             <div class="modal-body">
                                <div class="row">
                                   <div class="col-md-4 col-md-offset-1" style="padding-left:50px">
                                      <p class="input_field_fonts"><span style="color:red">*</span>Username:</p>
                                   </div>
                                   <div class="col-md-6">
                                      <s:textfield id="testUsername" name="testUsername" placeholder="Username" autofocus="true" required="true" cssClass="form-control"/>
                                   </div>
                                </div>
                                <div class="row">
                                   <div class="col-md-4 col-md-offset-1" style="padding-left:50px">
                                      <p class="input_field_fonts"><span style="color:red">*</span>Password:</p>
                                   </div>
                                   <div class="col-md-6">
                                      <s:password name="testPassword" placeholder="Password" required="true" cssClass="form-control"/>
                                   </div>
                                </div>
                             </div>
                             <div class="modal-footer">
                                <input type="submit" class="btn btn-primary btn-cnfrm" value="Test" />
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                             </div>
                          </form>
                          <!-- <div class="modal-footer">
                             <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                             <button type="button" class="btn btn-primary">Save changes</button>
                             </div> -->
                       </div>
                    </div>
                 </div>

                 <!-- /.modal -->
                 <div class="modal" tabindex="-1" role="dialog"
                     aria-labelledby="myModalLabel" aria-hidden="true" id="testLDAPAttributeConfiguration">
                    <div class="modal-dialog widthcontrol">
                        <div class="modal-content widthcontrol">
                            <div class="modal-header">

                                <h4 class="modal-title" style="text-align:center" >Test Attribute Mapping Configuration</h4>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" onclick="testLDAPAttributeMappingCancelOnClick()" aria-label="Close"></button>
                            </div>
                            <form id="testldapattributemappingform" autocomplete="off" method="post">
                                <s:hidden name="testIdentifier" id="ldapTestAttributueMappingIdentifier"/>
                                <s:token />
                                <div class="modal-body">
                                    <div class="row">
                                        <div class="col-md-4 col-md-offset-1" style="padding-left:50px">
                                            <p class="input_field_fonts"><span style="color:red">*</span>Username:</p>
                                        </div>
                                        <div class="col-md-6">
                                            <s:textfield id="testAttributeUsername" name="testUsername" placeholder="Username" autofocus="true" required="true" cssClass="form-control"/>
                                        </div>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <input name="testAttributeMappingButton" type="button" class="btn btn-primary btn-cnfrm" value="Test" onclick="testLDAPAttributeMappingButtonOnClick()" />

                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" onclick="testLDAPAttributeMappingCancelOnClick()">Cancel</button><br>
                                </div>
                            </form>
                            <section id="testldapattributemappingdisplay" style="display: none;">
                                <div>
                                    <h4 class="modal-title"  style="text-align:center" >Test Attribute Mapping Result</h4>
                                </div>
                                <div class="modal-body table-responsive">
                                    <table class="table table-striped" style="font-size: small">
                                        <tbody id="testldapattributemappingcontent" class="text-nowrap">
                 <%--						Here the whole content is handeled by the Jquery--%>
                                        </tbody>
                                    </table>
                                </div>
                            </section>
                        </div>
                        <!-- /.modal-content -->
                    </div>
                    <!-- /.modal-dialog -->
                 </div>

        <div class="container-fluid">
            <div class="card ldap-panel shadow">
                <div id="ldap-config" class="card-header">
                            <span class="float-start">
                                <h4 class="mt-2 h4">View LDAP Configurations</h4>
                            </span>
                    <span class="float-end">
                                <a class="btn btn-primary btn-ht orange-btn"
                                   onclick="window.location.href='addldapconfig'">Add LDAP Connection</a>
                            </span>
                        </div>
                        <div class="card-body">
                            <table id="example" class="table table-hover table-condensed tablewrap table_header_font configs-table">
                                <thead>
                                    <tr>
                                        <th>Identifier</th>
                                        <th>Domain Name</th>
                                        <th>Sync Enabled</th>
                                        <th>Action</th>

                                    </tr>
                                </thead>
                                <s:iterator value="gatewayConfigurationList" var="ldapConfiguration" status="stat">
                                      <tr class="gradeA">
                                        <td><s:property value="identifier" /></td>
                                        <td><s:property value="domainName" /></td>

                                        <td> <s:property value="addToScheduler" /></td>
                                        <td class="ldap-user">

                                                <div class="dropdown col-md-10 ">
                                       <div class="btn dropdown-toggle ldap-dropdown-toggle user-profile-wrapper" type="button" data-toggle="dropdown" aria-expanded="false">
                                           <a class="pm-0">Select<span class="caret"></span></a>
                                       </div>
                                       <ul class="dropdown-menu ldap-select-dropdown cursor-pointer dropdown-box">
                                          <li ><a class="editLdapLink" data-ldapid="<s:property value="identifier" />"><span class="fas fa-edit"></span> Edit</a></li>

                                          <li data-bs-toggle="modal" data-bs-target="#testLDAPConfiguration">
                                              <a class="testLdapConfigLink"
                                                data-idpname="<s:property value='identifier' />">
                                             <span class="fa fa-cogs"></span> Test Connection
                                             </a>
                                          </li>
                                          <li>
                                              <a  href="#" class="testLdapAttributeConfigLink"
                                                  data-idpname="<s:property value="identifier" />">
                                                  <span class="fa fa-map-signs"></span> Test Attribute Mapping
                                              </a>
                                          </li>

                                           <li class="deleteLdapLink" data-bs-toggle="modal" data-bs-target="#deleteLdapConfig" data-ldapid="<s:property value="identifier" />"><a ><span class="fa fa-trash"></span> Delete</a></li>

                                           <li><a class="enableSyncLink" data-ldapid="<s:property value="identifier" />"><s:if test="%{#ldapConfiguration.addToScheduler == true}"><span class="fa fa-minus-square"></span> Disable Sync</s:if><s:if test="%{#ldapConfiguration.addToScheduler == false}"><span class="fa fa-check-square"></span> Enable Sync</s:if></a></li>

                                           <li>
                                             <a href="show-change-history?ldapIdentifier=<s:property value='identifier' />">
                                               <span class="fa fa-history"></span> Show History
                                             </a>
                                           </li>

                                       </ul>
                                    </div>

                                </td>


                                    </tr>
                                </s:iterator>
                            </table>
                        <div class="ldap-connection-not-configured"
                            <s:if test="gatewayConfigurationList.size > 0">hidden</s:if> >
                           <div class="card-body">
                               <div class="alert alert-primary" role="alert">
                                <i class="fa fa-info-circle"></i> LDAP Connection is not configured. Please configure LDAP Connection by clicking on
                                       'Add LDAP Connection' button on top right.
                               </div>
                           </div>
                       </div>
                    <div class="pagination-wrapper">
                        <ul class="pagination position left-side">
                            <li name="myPrev" id="prev" class="disabled page-item shadow"><a class="page-link"
                                                                                             value="prev"
                                                                                             onclick="changeRange(this)">&laquo;</a>
                            </li>
                            <li name="myNext" id="next" class="next page-item shadow"><a class="page-link" value="next"
                                                                                         onclick="changeRange(this)">&raquo;</a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <form id="editldap_form" action="editldapconfig" method="post">
        <s:hidden name="identifier"/>
        <s:token/>
    </form>
    <form id="updatesync_form" action="updateconfigsync" method="post">
        <s:hidden name="identifier"/>
        <s:token/>
    </form>
    <form id="deleteldap_form" action="deleteldapconfig" method="post">
        <s:hidden name="identifier"/>
        <s:token/>
    </form>
    <script src="/miniorangegateway/js/jquery.dataTables.min.js"></script>
    <script src="/miniorangegateway/js/dataTables.bootstrap.js"></script>
    <script src="/miniorangegateway/js/modal.js"></script>
    <script>
        $(".editLdapLink").on("click", function () {
            //$('#loading_image').show();
            var id = $(this).data("ldapid");
            document.getElementById("editldap_form").elements[0].value = id;
            $("#editldap_form").submit();
        });
        $(".enableSyncLink").on("click", function () {
            //$('#loading_image').show();
            var id = $(this).data("ldapid");
            document.getElementById("updatesync_form").elements[0].value = id;
            $("#updatesync_form").submit();
        });
		$(".deleteLdapLink").on("click", function() {
			var id = $(this).data("ldapid");
			$('#deleteModalConfirmText').html("<p>Are you sure you want to delete <b>" + id + "</b>?</p>");
			$('#deleteLdapSubmit').on('click', function() {
				$('#deleteLdapConfig').modal('hide');
				document.getElementById("deleteldap_form").elements[0].value = id;
				$("#deleteldap_form").submit();
			});
		});
		$(".testLdapConfigLink").on("click", function() {
        		var name = $(this).data("idpname");
        		$('#ldapTestIdentifier').val(name);
        		$('#testLDAPConfiguration').modal('show');
        });

          $(".testLdapAttributeConfigLink").on("click", function() {
                var name = $(this).data("idpname");
                $('#ldapTestAttributueMappingIdentifier').val(name);
                $('#testldapattributemappingform').submit(false);
                $('#testLDAPAttributeConfiguration').modal('show');
            });

          function testLDAPAttributeMappingButtonOnClick() {
                     var testUsername=$("#testAttributeUsername").val();
                     $('#loading_image').show();
                     if(testUsername.trim()){
                         $("#testLDAPAttributeConfiguration").hide();
                         $.ajax({
                             type : "POST",
                             url : "testldapattributeconfiguration",
                             data : $("#testldapattributemappingform").serialize(),
                             success : function(data) {
                                 var index=0;
                                 var arrayLength=Object.keys(data).length;
                                 for(var key in data)
                                 {
                                     if(key==="Attribute Name")
                                         break;
                                     index++; //index=0 will indicate that no default attributes are mapped.
                                 }

                                 $("#testLDAPAttributeConfiguration").show();
                                 $("#testldapattributemappingcontent").empty();
                                 if(arrayLength>1)
                                 {
                                     if(index!=1)//if first key is not attribute name
                                     {
                                         $("#testldapattributemappingcontent").append(
                                                 "<tr style='background: #181c20;color: whitesmoke; text-align: center;'><td colspan=3><b>Suggested Attributes that you can map</b></td></tr>"+
                                                 "<tr><td scope='col'><b>&nbsp;</b></td><td scope='col' style='padding-right:50px'><b>Attribute Key</b></td><td scope='col'><b>Attribute Values</b></td></tr>"
                                         );
                                     }
                                     $.each(data , function( key, value ) {
                                         //console.log( key + ": " + value ); // Key : 10
                                         if(key==="Attribute Name")
                                         {
                                             $("#testldapattributemappingcontent").append(
                                                     "<tr style='background: #181c20;color: whitesmoke; text-align: center;'><td colspan=3><b>Configured Attributes Fetched for the User Account</b></td></tr>"+
                                                     "<tr><td scope='col'><b>&nbsp;</b></td><td scope='col'><b>Attribute Name</b></td><td scope='col'><b>Attribute Values</b></td></tr>"
                                             );
                                         }
                                         else{
                                             if(key!="pwdlastset")
                                             {
                                                $("#testldapattributemappingcontent").append(
                                                    "<tr>" +
                                                    "<td width='40%'>&nbsp;</td>" +"<td>"+key+"</td >" + "<td width='60%'>"+value+"</td>"+
                                                    "</tr>"
                                                 );
                                             }

                                         }

                                     });
                                 }
                                 else {
                                     $("#testldapattributemappingcontent").append(
                                             "<tr style='background: #181c20;color: whitesmoke;'><td colspan=2><b>User Could not be found.</b></td></tr>"
                                     );
                                 }

                                 $("#testldapattributemappingdisplay").show();
                                 $('#loading_image').hide();
                             },
                             error : function(data) {

                                 $("#testLDAPAttributeConfiguration").show();
                                 $("#testldapattributemappingcontent").empty();
                                 $("#testldapattributemappingcontent").append(
                                         "<tr style='background: #181c20;color: whitesmoke;'><td colspan=2><b>An Error occurred while receiving data.</b></td></tr>"
                                 );
                                 $("#testldapattributemappingdisplay").show();
                                 $('#loading_image').hide();
                             }
                         });
                     }
                     else {
                         alert("Please Enter a Valid Username");
                     }
                 }

        function testLDAPAttributeMappingCancelOnClick()
        {
            $('#testldapattributemappingdisplay').hide();
            $("#testldapattributemappingcontent").empty();
        }


	</script>
        <div class="modal" role="dialog" tabindex="-1" aria-labelledby="deleteLdapConfig" aria-hidden="true"
             data-backdrop="false" id="deleteLdapConfig">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Delete LDAP Source</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body" id="deleteModalConfirmText"></div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-bs-dismiss="modal">Cancel</button>
                        <button id="deleteLdapSubmit" type="button" class="btn btn-primary btn-cnfrm">Delete</button>
                    </div>
                </div>
            </div>
        </div>
<jsp:include page="footer.jsp" />
</body>
</html>