<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib prefix="s" uri="/struts-tags"%>
<html>
<head>
<link rel="stylesheet" href="css/style.css" />
<link rel="stylesheet" href="css/bootstrap/bootstrap.min.css" />
<link rel="shortcut icon" href="images/favicon.png">
<title>Configure User Mapping</title>
</head>
<body>
	<div class="header">
		<div class="container">
		<div class="row">
			<div class="col-md-1">
				<div class="logo"></div>
			</div>
			<div class="col-md-offset-10 col-md-1">
				<div id="logoutdiv" class="logout">
					<a href="adminlogout">Logout</a>
				</div>
			</div>
		</div>
	</div>
	<div class="container-fluid">
		<div class="row">
			<s:include value="menu.jsp">
				<s:param name="currentmenu" value="2" />
			</s:include>
			<div class="col-md-10 config_area">
			<div id="actionMessages">
				<s:if test="hasActionMessages()">
					<div id="display-success">
						<div class="alert alert-success alert-dismissible alert-custom"
							role="alert">
							<i class="glyphicon glyphicon-ok-circle glyph_pos "></i>
							<button type="button" class="altloginclose" data-dismiss="alert">&times;</button>
							<s:actionmessage escape="false" />
						</div>
					</div>
				</s:if>
				<s:if test="hasActionErrors()">
					<div id="display-error">
						<div class="alert alert-warning alert-dismissible walter-custom"
							role="alert">
							<i
								class="glyphicon glyphicon-exclamation-sign icon-place glyph-size"></i>
							<button type="button" class="errormsgclose" data-dismiss="alert">&times;</button>
							<s:actionerror escape="false" />
						</div>
					</div>
				</s:if>
			</div>			
				<div class="heading">Step 2: Configure miniOrange Gateway</div>
				<div class="panel panel-default">
					<div class="panel-heading">LDAP User Mapping Configuration</div>
					<div class="panel-body">
						<s:form id="configureLdapUserAttributes" action="ldapusermapping">
							<div class="col-md-8 ">
								<div class="row row_custom">
									<div class="col-md-4 label-font">
										<span class="red">*</span> DN Attribute:
									</div>
									<div class="col-md-4">
										<s:textfield name="dnAttribute" cssClass="form-control"
											placeholder="distinguishedName" required="true" />
									</div>
								</div>
								<br>
								<div class="row row_custom">
									<div class="col-md-4 label-font">
										<span class="red">*</span> SearchBase:
									</div>
									<div class="col-md-4">
										<s:textfield name="searchBase" cssClass="form-control"
											placeholder="dc=domain,dc=com" required="true" />
									</div>
								</div>
								<br>
								<div class="row row_custom">
									<div class="col-md-4 label-font">
										<span class="red">*</span> LDAP Search Filter:
									</div>
									<div class="col-md-4">
										<s:textfield name="ldapSearchFilter" cssClass="form-control"
											placeholder="(&(objectClass=user)(cn=?))" required="true" />
									</div>
								</div>
								<br> <br>
								<div class="col-md-btn">
									<a href="configureconnection"><input type="button"
										class="btn btn-primary btn-grey" value="Previous" /></a>
									<s:submit value="Save" cssClass="btn btn-warning" />
								</div>
								<br> <br>
							</div>
						</s:form>
					</div>
				</div>
			</div>
		</div>
	</div>
	<jsp:include page="footer.jsp" />
</body>
</html>