<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib prefix="s" uri="/struts-tags"%>
<html>
<head>
	<link rel="stylesheet" href="css/login.css"/>
	<link rel="stylesheet" href="css/bootstrap/bootstrap5-0-2.min.css"/>
	<link rel="stylesheet" href="css/fonts/fontawesome.min.css"/>
	<link rel="shortcut icon" href="images/favicon.png">
	<link rel="stylesheet" href="css/custom/login-extended.css"/>
	<script src="js/jquery-3.5.1.min.js"></script>
	<title>Administrator Login</title>
</head>

<s:hidden name="idpUrlInitialized" value="%{idpUrlInitialized}" id="idpUrlInitialized"/>
<s:hidden name="hasActionErrors" value="%{hasActionErrors()}" id="hasActionErrors"/>
<s:hidden name="cloudZonesUrlsJSON" value="%{cloudZonesUrlsJSON}" id="cloudZonesUrlsJSON"/>
<script src="js/custom/login-extended.js"></script>
<s:if test="hasActionErrors()">
    <script>
        $(document).ready(function() {
            $('.login_box').css('height','31em');
            window.closeerrmsg = function() {
                $('#display-error').hide();
                $('.login_box').css('height','26em');
            }
        });
    </script>
</s:if>

<body>
	<div class="container-fluid">
		<div class="row row_custom">
			<div class="col-xl-4"></div>
			<div class="col-xl-4">
				<div class="card shadow">
					<div id="actionMessages">
				 		<s:if test="hasActionMessages()">
							<div id="display-success">
								<div class="alert alert-success alert-dismissible alert-custom" role="alert">
									<button type="button" class="altloginclose" data-dismiss="alert">&times;</button>
									<s:actionmessage escape="false" />
								</div>
							</div>
						</s:if>
						<s:if test="hasActionErrors()">
							<div id="display-error">
								<div class="alert alert-warning alert-dismissible walter-custom" role="alert">
									<button type="button" class="errormsgclose" data-dismiss="alert" onclick="closeerrmsg()">&times;</button>
									<s:actionerror escape="false" />
								</div>
							</div>
						</s:if>
				 	</div>
					<s:form action="adminlogin" method="post" id="loginForm">
						<div class="login-group p-2">
                            <s:hidden name="idpUrlInitialized" value="%{idpUrlInitialized}" id="idpUrlInitialized"/>
							<div class="mo-logo-login text-center mt-4 mb-4">
								<img src="./images/mologo.png">
							</div>

							<!-- show idpurlsettings.jsp only if idpUrlInitialized == false -->
                            <s:if test="!idpUrlInitialized">
                                <jsp:include page="idpurlsettings.jsp" />
                            </s:if>

							<div>
							<div class="input-group login-field text-padding ps-5 pe-5 left-glyphicon">
								<i class="fas fa-user custom-icon"></i>
								<s:textfield name="username" cssClass="form-control" placeholder="Username" autofocus="true" required="true"/>
								<br>
							</div>
							<br>
							<div class="input-group login-field text-padding ps-5 pe-5 left-glyphicon">
								<i class="fas fa-lock custom-icon"></i>
								<s:password name="password"	cssClass="form-control" placeholder="Password" required="true"/>
								<br>
							</div>
							<br>
							<div class="text-center login-button">
								<s:submit cssClass="btn login-btn orange-btn ms-3"/>
							</div>
						</div>
					</s:form>
					<s:if test="hasActionErrors()">
						<script>
							$('.login_box').css('height','31em');
							function closeerrmsg(){
								$('#display-error').hide();
								$('.login_box').css('height','26em');
							}
						</script>
					</s:if>
				</div>
			</div>
		</div>
	</div>
</body>
</html>