<%@ taglib prefix="s" uri="/struts-tags"%>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate" />
    <meta http-equiv="Pragma" content="no-cache" />
    <meta http-equiv="Expires" content="0" />
    <link rel="shortcut icon" href="images/favicon.png">
    <title>Manage Additional Admins</title>
    <link rel="stylesheet" href="css/style.css" />
    <link rel="stylesheet" href="css/bootstrap/bootstrap.min.css">
    <link rel="stylesheet" href="css/admin_style.css">
    <link rel="stylesheet" href="css/jquery.dataTables.min.css">
    <link rel="stylesheet" href="css/normalise.css">
    <link rel="stylesheet" href="css/jquery.dataTables.min.css">
    <link rel="stylesheet" href="css/bootstrap/dataTables.bootstrap.css">
</head>
<body>
<div class="header">
    <div class="container">
        <div class="row">
            <div class="col-md-1">
                <div class="logo"></div>
            </div>
            <div class="col-md-offset-10 col-md-1">
                <div id="logoutdiv" class="logout">
                    <a href="adminlogout">Logout</a>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row row_margin">
    <s:include value="menu.jsp">
        <s:param name="currentmenu" value="4" />
    </s:include>
    <div class="col-md-display">
        <div class="col-md-offset-0">
            <div class="jumbotron" >
                <div class="container">
                    <div id="actionMessages">
                        <s:include value="actionmessages.jsp"/>
                    </div>

                    <div class="panel panel-default panel-height">
                        <div class="panel-heading">
                            <div class="col-md-9 heading_font">
                                <h4>Manage Additional Admins</h4>
                            </div>
                            <div class="text-right">
                                <a class="btn btn-primary btn-ht" onclick="window.location.href='setadditionaladminaccount'">Add Additional Admin</a>
                            </div>
                        </div>
                        <div class="panel-body left-side">
                            <table id="example" class="table">
                                <thead>
                                <tr>
                                    <th>Username</th>
                                    <th>Action</th>
                                </tr>
                                </thead>

                                <s:iterator value="adminUsernameArray" var="adminUsername" status="stat">
                                    <tr class="gradeA">
                                        <td><s:property value="adminUsername" /></td>
                                        <td><s:if test="%{#adminUsername == currentusername}"> <a class="changePassword" data-username="<s:property value="adminUsername" />">Change Password</a></s:if>
                                            <s:if test="%{#adminUsername != currentusername}"> <a class="deleteAdmin" data-username="<s:property value="adminUsername" />">Delete</a></s:if>
                                        </td>
                                    </tr>
                                </s:iterator>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<jsp:include page="footer.jsp" />
<form id="changepassword_form" action="showchangepassword" method="post">
    <s:hidden key="adminUsername" />
    <s:token />
</form>
<form id="deleteadmin_form" action="deleteAdmin" method="post">
    <s:hidden key="adminUsername" />
    <s:token />
</form>
</body>

<script src="/miniorangegateway/js/modal.js"></script>
<script>
    $(".changePassword").on("click", function() {
        //$('#loading_image').show();
        var id = $(this).data("username");
        document.getElementById("changepassword_form").elements[0].value = id;
        $("#changepassword_form").submit();
    });
    $(".deleteAdmin").on("click", function() {
        var id = $(this).data("username");
        $('#deleteAdminConfirmText').html("<p>Are you sure you want to delete <b>" + id + "</b>?</p>");
        $('#deleteAdmin').modal('show');
        $('#deleteAdminSubmit').on('click', function() {
            $('#deleteAdmin').modal('hide');
            //$('#loading_image').show();
            document.getElementById("deleteadmin_form").elements[0].value = id;
            $("#deleteadmin_form").submit();
        });
    });
</script>
<script>
    $(document).ready(function() {
        $('#loading_image').hide();
        oTable = $('#example').dataTable({
            "dom": 'rt<"clear">',
            "bJQueryUI" : true,
            "sPaginationType" : "full_numbers",
            "sFilter":"dataTables_filter form-control",
            "bStateSave" : true,
            "iDisplayLength" : 10,
            "oLanguage": { "sSearch": "" },
            "aLengthMenu" : [ [ 10, 20, 50, -1 ], [ 10, 20, 50, "All" ] ],
            aoColumnDefs : [ {
                bSortable : false,
                aTargets : [ -1 ]
            } ],
            "aaSorting" : [ [ 0, "asc" ] ]
        });
    });
</script>
<div class="modal" tabindex="-1" role="dialog"
     aria-labelledby="myModalLabel" aria-hidden="true" id="deleteAdmin">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <div class="close-custom" data-dismiss="modal"></div>
                <h4 class="modal-title">Delete Gateway Admin</h4>
            </div>
            <div class="modal-body" id="deleteAdminConfirmText">

            </div>
            <div class="modal-footer">
                <button type="button" id="deleteAdminSubmit"
                        class="btn btn-primary btn-cnfrm">Yes</button>
                <button type="button" class="btn btn-default btn-cancel"
                        data-dismiss="modal">No</button>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>

</html>
