<%@ taglib prefix="s" uri="/struts-tags"%>
<!DOCTYPE html>
<html>
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate" />
        <meta http-equiv="Pragma" content="no-cache" />
        <meta http-equiv="Expires" content="0" />
        <link rel="shortcut icon" href="images/favicon.png">
        <title>Profile</title>
    <link rel="stylesheet" href="css/style.css" />
    <link rel="stylesheet" href="css/bootstrap/bootstrap5-0-2.min.css">
    <link rel="stylesheet" href="css/admin_style.css">
    <link rel="stylesheet" href="css/jquery.dataTables.min.css">
    <link rel="stylesheet" href="css/normalise.css">
    <link rel="stylesheet" href="css/jquery.dataTables.min.css">
    <link rel="stylesheet" href="css/bootstrap/dataTables.bootstrap.css">
    <script src="js/jquery-3.5.1.min.js"></script>
    <script src="js/pagination.js"></script>
	<link rel="stylesheet" href="css/custom/login-extended.css"/>
    <s:hidden name="cloudZonesUrlsJSON" value="%{cloudZonesUrlsJSON}" id="cloudZonesUrlsJSON"/>


    </head>
    <body class="white">
        <jsp:include page="header.jsp" />
        <div class="row me-0">
            <div class="col-md-2 me-0">
                <s:include value="menu.jsp">
                    <s:param name="currentmenu" value="0" />
                </s:include>
            </div>

            <div class="col-md-10 mt-4">
                 <div class="container-fluid" id="actionMessages">
                    <s:include value="actionmessages.jsp"/>
                </div>
                <div class="container-fluid">
                    <div class="card ldap-panel shadow">
                        <div class="card-header">
                            <h4 class="h4 mt-2">Profile Information</h4>
                        </div>
                        <div class="card-body">
                          <s:form id="profileform" action="profileform" method="post">
                              <div class="buildversion profile-field row m-3 p-3" id="buildversion">
                                  <div class="col-md-3">
                                      <h6 class="h6 pt-1">Build Version:</h6>
                                  </div>
                                  <div class="col-md-6">
                                      <label class="form-control-plaintext"><s:property value="buildVersion"/></label>
                                  </div>
                              </div>
                            <div class="username profile-field row m-3 p-3" id="username">
                                <div class="col-md-3">
                                     <h6 class="h6 pt-1">Username:</h6>
                                </div>
                                <div class="col-md-6">
                                    <s:textfield name="username" cssClass="form-control" placeholder="Username" value="%{#session.username}" disabled="true"/>
                                </div>
                                <br>
                            </div>
                            <div class="cust_id profile-field row m-3 p-3" id="cust_id">
                                <div class="col-md-3">
                                    <h6 class="h6 pt-1">Customer ID:</h6>
                                </div>
                                <div class="col-md-6">
                                    <s:textfield name="custid" cssClass="form-control" placeholder="Customer ID" value="%{customerId}" disabled="true"/>
                                </div>
                                <br>
                            </div>
                             <div class="domainName profile-field row m-3 p-3" id="domainName">
                                <div class="col-md-3">
                                    <h6 class="h6 pt-1">miniOrange Gateway Domain:</h6>
                                </div>
                                <div class="col-md-6">
                                    <s:textfield name="domainName" cssClass="form-control" placeholder="hostname.domain.com" value="%{domainName}" />
                                </div>
                                <input type="hidden" id="gatewayScheme" name="gatewayScheme"/>
                             </div>
                             <div class="token profile-field row m-3 p-3" id="token">
                                <div class="col-md-5 col-md-offset-3">
                                    <input type="submit" value="Save"
                                           class="btn orange-btn col-md-2 margin-right" />
                                </div>
                            </div>
                                </s:form>
                        </div>

                <hr style="height:2px;border-width:0;color:gray;background-color:gray;padding:2px">


                       <div class="mx-auto my-3" style="max-width: 700px;">
                         <div class="alert alert-danger text-center" role="alert">
                           <strong>Warning:</strong> Modifying the IDP URL may disrupt login functionality for all users. Proceed with caution and ensure the URL is correct.
                         </div>
                       </div>


                        <div class="current-idp-url profile-field row m-3 p-3" id="currentIdpUrlBox">
                            <div class="col-md-3">
                                <h6 class="h6 pt-1">Current IDP URL:</h6>
                            </div>
                            <div class="col-md-6">
                                <s:textfield name="currentIdpUrl"
                                             cssClass="form-control"
                                             value="%{currentIdpUrl}"
                                             readonly="true" />
                            </div>
                        </div>

                        <s:form id="deploymentForm" action="save-deployment-settings" method="post">
                            <div class="mx-auto mb-5" style="max-width: 700px;">
                                <jsp:include page="idpurlsettings.jsp" />
                                <div class="mt-3 text-center">
                                    <input type="submit" value="Save Deployment Settings" class="btn orange-btn" />
                                </div>
                            </div>
                        </s:form>
                    </div>
                </div>
            </div>
        </div>
        <jsp:include page="footer.jsp" />
    </body>
</html>


<script>
$(document).ready(function () {
    const $urlInput = $('#idpUrl');
    const $feedback = $('#idpUrlFeedback');

    $('#deploymentForm').submit(function(e) {
        const deploymentType = $('input[name="deploymentType"]:checked').val();
        const url = $urlInput.val().trim();
        const urlPattern = /^(http|https):\/\/[^\s/$.?#].[^\s]*$/i;

        $urlInput.removeClass('is-invalid');
        $feedback.hide();

        if (deploymentType === 'onpremise') {
            if (!url) {
                e.preventDefault();
                $urlInput.addClass('is-invalid');
                $feedback.text('Please enter an IDP URL.').show();
                return false;
            }

            if (!urlPattern.test(url)) {
                e.preventDefault();
                $urlInput.addClass('is-invalid');
                $feedback.text('Please enter a valid URL starting with http:// or https://').show();
                return false;
            }
        }

        return true;
    });

    $urlInput.on('input', function () {
        $(this).removeClass('is-invalid');
        $feedback.hide();
    });

    $('input[name="deploymentType"]').on('change', function () {
        if ($(this).val() === 'cloud') {
            $urlInput.removeClass('is-invalid');
            $feedback.hide();
        }
    });
});
</script>
