<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib prefix="s" uri="/struts-tags"%>
<html>
<head>
<link rel="stylesheet" href="css/style.css" />
<link rel="stylesheet" href="css/bootstrap/bootstrap.min.css" />
<link rel="shortcut icon" href="images/favicon.png">
<title>Configuration Details</title>
</head>
<body>
	<div class="header">
		<div class="logo"></div>
		<div id="logoutdiv">
			<a href="adminlogout">Logout</a>
		</div>
	</div>
	<div class="container-fluid">
		<div class="row">
			<s:include value="menu.jsp">
				<s:param name="currentmenu" value="3" />
			</s:include>
			<div class="col-md-10 config_area">
				<div id="actionMessages">
					<s:if test="hasActionMessages()">
						<div id="display-success">
							<div class="alert alert-success alert-dismissible alert-custom"
								role="alert">
								<i class="glyphicon glyphicon-ok-circle glyph_pos "></i>
								<button type="button" class="altloginclose" data-dismiss="alert">&times;</button>
								<s:actionmessage escape="false" />
							</div>
						</div>
					</s:if>
					<s:if test="hasActionErrors()">
						<div id="display-error">
							<div class="alert alert-warning alert-dismissible walter-custom"
								role="alert">
								<i
									class="glyphicon glyphicon-exclamation-sign icon-place glyph-size"></i>
								<button type="button" class="errormsgclose" data-dismiss="alert">&times;</button>
								<s:actionerror escape="false" />
							</div>
						</div>
					</s:if>
				</div>
				<div class="heading"></div>
				<div class="panel panel-default">
					<div class="panel-heading">Configuration Details</div>
					<div class="panel-body">
						<div class="row row_custom">
							<div class="col-md-4 label-font">LDAP Server:</div>
							<div class="col-md-8">
								<b><s:property value="ldapServer" /></b>
							</div>
						</div>
						<br>
						<div class="row row_custom">
							<div class="col-md-4 label-font">Service Account DN:</div>
							<div class="col-md-8">
								<b><s:property value="bindAccountDN" /></b>
							</div>
						</div>
						<br>
						<div class="row row_custom">
							<div class="col-md-4 label-font">Service Account Password:</div>
							<div class="col-md-8">
								<b><s:iterator begin="0" end="bindAccountPassword.length()">*</s:iterator></b>
							</div>
						</div>
						<br>
						<div class="row row_custom">
							<div class="col-md-4 label-font">DN Attribute:</div>
							<div class="col-md-8">
								<b><s:property value="dnAttribute" /></b>
							</div>
						</div>
						<br>
						<div class="row row_custom">
							<div class="col-md-4 label-font">LDAP Search Filter:</div>
							<div class="col-md-8">
								<b><s:property value="ldapSearchFilter" /></b>
							</div>
						</div>
						<br>
						<br>
						<div class="col-md-btn">
							<a href="configureconnection"><input type="button"
								class="btn btn-primary btn-grey" value="Modify Configuration" /></a> <a
								href="login"><input type="button" class="btn btn-warning"
								value="Try User Login" /></a>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<jsp:include page="footer.jsp" />
</body>
</html>