<%@ taglib prefix="s" uri="/struts-tags"%>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate" />
    <meta http-equiv="Pragma" content="no-cache" />
    <meta http-equiv="Expires" content="0" />
    <link rel="shortcut icon" href="images/favicon.png">
    <title>Event Logs</title>
    <link rel="stylesheet" href="css/style.css" />
    <link rel="stylesheet" href="css/bootstrap/bootstrap5-0-2.min.css">
    <link rel="stylesheet" href="css/admin_style.css">
    <link rel="stylesheet" href="css/jquery.dataTables.min.css">
    <link rel="stylesheet" href="css/normalise.css">
    <link rel="stylesheet" href="css/jquery.dataTables.min.css">
    <link rel="stylesheet" href="css/bootstrap/dataTables.bootstrap.css">
    <script src="js/jquery-3.5.1.min.js"></script>
    <script src="js/showlogs.js"></script>
    <script src="js/pagination.js"></script>
</head>
<body class="white">
    <jsp:include page="header.jsp" />
    <div class="row me-0">
        <div class="col-md-2">
            <s:include value="menu.jsp">
                <s:param name="currentmenu" value="5" />
            </s:include>
        </div>
        <div class="col-md-10 mt-4">
            <div id="actionMessages">
                <s:include value="actionmessages.jsp"/>
            </div>

            <div class="container-fluid">
                <div class="card ldap-panel shadow">
                    <div class="card-header">
                        <h4 class="h4 mt-2">Event Logs</h4>
                    </div>
                    <div class="card-body">
                        <div class="filter-wrapper row">
                            <div class="col-md-6">
                                <span class="pull-left search-wrapper">
                                    <input name="search" id="logssearchbox" class="logssearchbox" onkeyup="searchLogs(this.value)" placeholder="Search">
                                    <buttom class="srch-btn"><i class="glyphicon glyphicon-search ldap-search"></i></buttom>
                                </span>
                            </div>
                            <div class="col-md-6">
                                <span class="float-end">
                                    <input type="submit" id="logsdeletebutton" value="Delete Logs" data-bs-toggle="modal"  data-bs-target="#deleteLdapLogs"  class="deleteEventLogs btn btn-danger btn-ht" />
                                </span>
                            </div>
                        </div>
                        <div class="ldap-table-wrapper">
                            <table id="example" class="table table-hover table-condensed tablewrap table_header_font logs-table table-bordered">
                                <thead>
                                <tr>
                                    <th>IP Address</th>
                                    <th>Username</th>
                                    <th>Timestamp<span class="fa fa-sort float-end" onclick="changeOrder()"></span></th>
                                    <th>Action</th>
                                </tr>
                                </thead>
                                <tbody></tbody>
                            </table>
                            <s:hidden id="gatewaylogs" value="%{gatewayLogsJSON}" name="gatewayLogs"/>
                            <div class="no-record-found">
                                <h3 class="text-center">No Records Found!!</h3>
                            </div>
                        </div>
                    </div>
                    <div class="pagination-wrapper">
                        <ul class="pagination position left-side">
                            <li name ="myPrev" id="prev" class="disabled page-item shadow"><a class="page-link" value="prev" onclick="changeRange(this)">&laquo;</a></li>
                            <li name="myNext" id="next" class="next page-item shadow"><a class="page-link" value="next" onclick="changeRange(this)">&raquo;</a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <form id="deletelogs_form" action="deletelogs" method="post">
        <s:hidden name="identifier"/>
        <s:token/>
    </form>

    <script src="/miniorangegateway/js/modal.js"></script>
    <script>
        $( document ).ready(function() {
            var rowcount =  document.getElementById("example").rows.length;
            if(rowcount == 1 ){
                $('#logsdeletebutton').attr('disabled','disabled');

            }

        });
    $(".deleteEventLogs").on("click", function() {
        var id = $(this).data("ldapid");
        $('#deleteLogsSubmit').on('click', function() {
            $('#deleteLdapLogs').modal('hide');
            document.getElementById("deletelogs_form").elements[0].value = id;
            $("#deletelogs_form").submit();
        });
    });

    </script>

    <div class="modal" role="dialog" tabindex="-1" aria-labelledby="deleteLdapLogs" aria-hidden="true"
             data-backdrop="false" id="deleteLdapLogs">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Delete Logs</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body"><p>Are you sure you want to delete the logs ?</p></div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-bs-dismiss="modal">Cancel</button>
                        <button id="deleteLogsSubmit" type="button" class="btn btn-primary btn-cnfrm">Delete</button>
                    </div>
                </div>
            </div>
        </div>

    <jsp:include page="footer.jsp" />
</body>
</html>





