/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.app.helpers;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.miniorange.app.helpers.MoSAMLSettings;
import com.miniorange.app.helpers.MoSAMLUtils;
import com.miniorange.saml.MiniorangeAuthProvider;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

public class MoSAMLFeedback {
    private static Logger LOGGER = Loggers.get(MiniorangeAuthProvider.class);
    MoSAMLSettings settings;
    private String feedbackContent;
    private String feedbackEmail;
    private String feedbackName;

    public MoSAMLFeedback(MoSAMLSettings settings) {
        this.settings = settings;
    }

    public void sendFeedback(HttpServletRequest request, HttpServletResponse response) {
        try {
            this.feedbackContent = (String)StringUtils.defaultIfEmpty((CharSequence)request.getParameter("moSAMLFeedbackQuery"), (CharSequence)"");
            this.feedbackEmail = (String)StringUtils.defaultIfEmpty((CharSequence)request.getParameter("moSAMLFeedbackEmail"), (CharSequence)"");
            this.feedbackName = (String)StringUtils.defaultIfBlank((CharSequence)request.getParameter("moSAMLFeedbackName"), (CharSequence)"");
            LOGGER.debug("Feedback received, Name :" + this.feedbackName + ", Email: " + this.feedbackEmail + ", Query: " + this.feedbackContent);
            String content = "";
            content = content + "Hello,<br><br>Name: " + this.feedbackName + "<br><br>Email: " + this.feedbackEmail + "<br><br>Plugin Name: " + "SonarQube SAML Plugin" + "<br><br>SonarQube Version: " + this.settings.getSonarQubeVersion();
            content = content + "<br><br>Details: " + this.feedbackContent;
            content = content + "<br><br>Thanks<br>miniOrange";
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("customerKey", "16555");
            jsonObject.addProperty("sendEmail", Boolean.valueOf(true));
            JsonObject emailObject = new JsonObject();
            emailObject.addProperty("customerKey", "16555");
            emailObject.addProperty("fromEmail", "no-reply@xecurify.com");
            emailObject.addProperty("bccEmail", "no-reply@xecurify.com");
            emailObject.addProperty("fromName", "miniOrange");
            emailObject.addProperty("toEmail", "atlassiansupport@xecurify.com");
            emailObject.addProperty("toName", "atlassiansupport@xecurify.com");
            emailObject.addProperty("bccEmail", "atlassiansupport@xecurify.com");
            emailObject.addProperty("subject", "Feedback for SonarQube SAML Plugin");
            emailObject.addProperty("content", content);
            jsonObject.add("email", (JsonElement)emailObject);
            String jsonString = jsonObject.toString();
            LOGGER.debug("Sending Request... ");
            StringBuilder url = new StringBuilder("https://login.xecurify.com/moas");
            url.append("https://login.xecurify.com/moas/api/notify/send");
            String response1 = MoSAMLUtils.sendPostRequest(url.toString(), jsonString, "application/json", MoSAMLFeedback.getAuthorizationHeaders(Long.valueOf("16555"), "fFd2XcvTGDemZvbw1bcUesNJWEqKbbUq"));
            LOGGER.debug("Send_feedback response: " + response1);
            response.sendRedirect("/admin/extension/miniorangesamlplugin/mo_support_page");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static HashMap<String, String> getAuthorizationHeaders(Long customerId, String apiKey) {
        HashMap<String, String> headers = new HashMap<String, String>();
        Long timestamp = System.currentTimeMillis();
        String stringToHash = customerId + timestamp + apiKey;
        String hashValue = DigestUtils.sha512Hex((String)stringToHash);
        headers.put("Customer-Key", String.valueOf(customerId));
        headers.put("Timestamp", String.valueOf(timestamp));
        headers.put("Authorization", hashValue);
        return headers;
    }

    public String getFeedbackContent() {
        return this.feedbackContent;
    }

    public void setFeedbackContent(String feedbackContent) {
        this.feedbackContent = feedbackContent;
    }

    public String getFeedbackEmail() {
        return this.feedbackEmail;
    }

    public void setFeedbackEmail(String feedbackEmail) {
        this.feedbackEmail = feedbackEmail;
    }

    public String getFeedbackName() {
        return this.feedbackName;
    }

    public void setFeedbackName(String feedbackName) {
        this.feedbackName = feedbackName;
    }

    public String getPluginConfiguration() {
        StringBuilder str = new StringBuilder("*** PLUGIN CONFIGURATION ***");
        str = str.append("Is ENABLED: " + this.settings.isEnabled() + "Is SIGN-UP ALLOWED: " + this.settings.allowSignUp() + "IDP NAME: " + this.settings.getIdpName() + "IDP ENTITY ID: " + this.settings.getIdpEntityId() + "SSO LOGIN URL: " + this.settings.getSamlLoginUrl() + "IDP X509 CERTIFICATE: " + this.settings.getX509Certificate() + "LOGIN ATTRIBUTE NAME: " + this.settings.getLoginAttr() + "NAME ATTRIBUTE NAME: " + this.settings.getNameAttr() + "SAML LOGIN BINDING TYPE: " + this.settings.getSamlLoginBindingType() + "SP BASE URL: " + this.settings.getSpBaseUrl() + "SP ENTITY ID: " + this.settings.getSpEntityId() + "SP PRIVATE CERTIFICATE: " + this.settings.getPrivateSPCertificate() + "SP PUBLIC CERTIFICATE: " + this.settings.getPublicSPCertificate());
        return str.toString();
    }
}

