/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.app.helpers;

import com.miniorange.app.classes.MoSAMLException;
import com.miniorange.app.classes.MoSAMLResponse;
import com.miniorange.app.helpers.MoSAMLSettings;
import com.miniorange.app.helpers.MoSAMLUtils;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.opensaml.Configuration;
import org.opensaml.common.SignableSAMLObject;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.AttributeStatement;
import org.opensaml.saml2.core.Audience;
import org.opensaml.saml2.core.AudienceRestriction;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.core.AuthnStatement;
import org.opensaml.saml2.core.NameID;
import org.opensaml.saml2.core.Response;
import org.opensaml.saml2.core.SubjectConfirmation;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.signature.SignableXMLObject;
import org.opensaml.xml.signature.X509Certificate;
import org.opensaml.xml.signature.X509Data;
import org.opensaml.xml.validation.ValidationException;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MoSAMLManager {
    private String certificateExpected = "";
    private String replacement = "";
    private static Logger LOGGER = Loggers.get(MoSAMLManager.class);
    private static final String UTF_8 = "UTF-8";
    private static final String HTTPPOST = "HttpPost";

    public void createAuthnRequestAndRedirect(HttpServletResponse response, HttpServletRequest request, String relayState, MoSAMLSettings settings) {
        try {
            LOGGER.debug("Creating Authentication Request  and redirecting user to Idp for authentication");
            MoSAMLUtils.doBootstrap();
            AuthnRequest authnRequest = MoSAMLUtils.buildAuthnRequest(settings.getSpEntityId(), settings.getAcsUrl(), settings.getSamlLoginUrl(), settings.getNameIDFormat());
            if (StringUtils.equals((CharSequence)settings.getSamlLoginBindingType(), (CharSequence)HTTPPOST)) {
                LOGGER.debug("HTTP-POST Binding selected for SSO");
                String encodedAuthnRequest = MoSAMLUtils.base64EncodeRequest((XMLObject)authnRequest, Boolean.TRUE);
                String form = this.createHttpPostRequestForm(settings.getSamlLoginUrl(), encodedAuthnRequest, relayState);
                response.setContentType("text/html");
                response.getOutputStream().write(form.getBytes(StandardCharsets.UTF_8));
                response.getOutputStream().close();
            } else {
                LOGGER.debug("HTTP-Redirect Binding selected for SSO");
                String encodedAuthnRequest = MoSAMLUtils.base64EncodeRequest((XMLObject)authnRequest, false);
                String urlForSignature = this.createRequestQueryParamsForSignature(encodedAuthnRequest, relayState);
                String signature = MoSAMLUtils.signHttpRedirectRequest(urlForSignature, "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", settings.getPublicSPCertificate(), settings.getPrivateSPCertificate());
                String redirectUrl = this.createUnSignedRedirectURL(settings.getSamlLoginUrl(), encodedAuthnRequest, relayState, false);
                MoSAMLManager.httpRedirect(response, redirectUrl);
            }
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("An unknown error occurred while creating the AuthnRequest.", (Throwable)e);
            throw new MoSAMLException(MoSAMLException.SAMLErrorCode.UNKNOWN);
        }
    }

    public static void httpRedirect(HttpServletResponse response, String redirectUrl) throws IOException {
        LOGGER.debug("Redirecting user to " + redirectUrl);
        response.sendRedirect(redirectUrl);
    }

    public String getTestAuthnRequest(MoSAMLSettings settings) {
        try {
            LOGGER.debug("Creating Authentication Request.");
            MoSAMLUtils.doBootstrap();
            AuthnRequest authnRequest = MoSAMLUtils.buildAuthnRequest(settings.getSpBaseUrl(), settings.getAcsUrl(), settings.getSamlLoginUrl(), settings.getNameIDFormat());
            if (StringUtils.equals((CharSequence)settings.getSamlLoginBindingType(), (CharSequence)HTTPPOST)) {
                authnRequest = (AuthnRequest)MoSAMLUtils.signHttpPostRequest((SignableSAMLObject)authnRequest, settings.getPublicSPCertificate(), settings.getPrivateSPCertificate());
            }
            Marshaller marshaller = Configuration.getMarshallerFactory().getMarshaller((XMLObject)authnRequest);
            Element authDOM = marshaller.marshall((XMLObject)authnRequest);
            Document doc = authDOM.getOwnerDocument();
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("encoding", UTF_8);
            transformer.setOutputProperty("indent", "yes");
            StringWriter out = new StringWriter();
            transformer.transform(new DOMSource(doc), new StreamResult(out));
            return ((Object)out).toString();
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while creating the AuthnRequest.", (Throwable)e);
            throw new MoSAMLException(MoSAMLException.SAMLErrorCode.UNKNOWN);
        }
    }

    private String createRequestQueryParamsForSignature(String httpRedirectRequest, String relayState) throws UnsupportedEncodingException {
        LOGGER.debug("Creating request query parameter for signature");
        StringBuilder urlForSignature = new StringBuilder();
        urlForSignature.append("SAMLRequest").append("=").append(URLEncoder.encode(httpRedirectRequest, StandardCharsets.UTF_8.toString()));
        urlForSignature.append("&").append("RelayState").append("=");
        if (StringUtils.isNotBlank((CharSequence)relayState)) {
            urlForSignature.append(URLEncoder.encode(relayState, StandardCharsets.UTF_8.toString()));
        } else {
            urlForSignature.append(URLEncoder.encode("/", StandardCharsets.UTF_8.toString()));
        }
        return urlForSignature.toString();
    }

    private String createResponseQueryParamsForSignature(String httpRedirectResponse, String relayState) throws UnsupportedEncodingException {
        LOGGER.debug("Creating response query parameter for signature");
        StringBuilder urlForSignature = new StringBuilder();
        urlForSignature.append("SAMLResponse").append("=").append(URLEncoder.encode(httpRedirectResponse, StandardCharsets.UTF_8.toString()));
        urlForSignature.append("&").append("RelayState").append("=");
        if (StringUtils.isNotBlank((CharSequence)relayState)) {
            urlForSignature.append(URLEncoder.encode(relayState, StandardCharsets.UTF_8.toString()));
        } else {
            urlForSignature.append(URLEncoder.encode("/", StandardCharsets.UTF_8.toString()));
        }
        return urlForSignature.toString();
    }

    private String createRedirectURL(String url, String samlRequestOrResponse, String relayState, String sigAlgo, String signature, Boolean isResponse) throws UnsupportedEncodingException {
        StringBuilder builder = new StringBuilder(url);
        if (StringUtils.contains((CharSequence)url, (CharSequence)"?") && !StringUtils.endsWith((CharSequence)url, (CharSequence)"?") && !StringUtils.endsWith((CharSequence)url, (CharSequence)"&")) {
            builder.append("&");
        } else if (!StringUtils.contains((CharSequence)url, (CharSequence)"?")) {
            builder.append("?");
        }
        if (isResponse.booleanValue()) {
            builder.append(this.createResponseQueryParamsForSignature(samlRequestOrResponse, relayState));
        } else {
            builder.append(this.createRequestQueryParamsForSignature(samlRequestOrResponse, relayState));
        }
        builder.append("&").append("SigAlg").append("=").append(URLEncoder.encode(sigAlgo, UTF_8)).append("&").append("Signature").append("=").append(URLEncoder.encode(signature, UTF_8));
        return builder.toString();
    }

    private String createUnSignedRedirectURL(String url, String samlRequestOrResponse, String relayState, Boolean isResponse) throws UnsupportedEncodingException {
        StringBuilder builder = new StringBuilder(url);
        if (StringUtils.contains((CharSequence)url, (CharSequence)"?") && !StringUtils.endsWith((CharSequence)url, (CharSequence)"?") && !StringUtils.endsWith((CharSequence)url, (CharSequence)"&")) {
            builder.append("&");
        } else if (!StringUtils.contains((CharSequence)url, (CharSequence)"?")) {
            builder.append("?");
        }
        if (isResponse.booleanValue()) {
            builder.append(this.createResponseQueryParamsForSignature(samlRequestOrResponse, relayState));
        } else {
            builder.append(this.createRequestQueryParamsForSignature(samlRequestOrResponse, relayState));
        }
        return builder.toString();
    }

    private String createHttpPostRequestForm(String ssoUrl, String encodedRequest, String relayState) {
        StringBuilder form = new StringBuilder("<html><head>");
        form.append("<script src=\"https://ajax.googleapis.com/ajax/libs/jquery/1.8.3/jquery.min.js\"></script>");
        form.append("<script type=\"text/javascript\">$(document).ready( function() { document");
        form.append(".forms['saml-request-form'].submit(); });</script></head>");
        form.append("<body>Please wait...<form action=\"" + ssoUrl + "\" method=\"post\" id=\"saml-request-form\">");
        form.append("<input type=\"hidden\" name=\"SAMLRequest\" value=\"" + MoSAMLUtils.htmlEncode(encodedRequest) + "\" />");
        form.append("<input type=\"hidden\" name=\"RelayState\" value=\"" + MoSAMLUtils.htmlEncode(relayState) + "\" />");
        form.append("</form></body></html>");
        return form.toString();
    }

    private String createHttpPostResponseForm(String ssoUrl, String encodedResponse, String relayState) {
        StringBuilder form = new StringBuilder("<html><head>");
        form.append("<script src=\"https://ajax.googleapis.com/ajax/libs/jquery/1.8.3/jquery.min.js\"></script>");
        form.append("<script type=\"text/javascript\">$(document).ready(function() { ");
        form.append("document.forms['saml-request-form'].submit(); });</script></head>");
        form.append("<body>Please wait...<form action=\"" + ssoUrl + "\" method=\"post\" id=\"saml-request-form\">");
        form.append("<input type=\"hidden\" name=\"MoSAMLResponse\" value=\"" + MoSAMLUtils.htmlEncode(encodedResponse) + "\" />");
        form.append("<input type=\"hidden\" name=\"RelayState\" value=\"" + MoSAMLUtils.htmlEncode(relayState) + "\" />");
        form.append("</form></body></html>");
        return form.toString();
    }

    public MoSAMLResponse readSAMLResponse(HttpServletRequest request, MoSAMLSettings settings) {
        try {
            LOGGER.debug("in readSAMLResponse() method.");
            MoSAMLUtils.doBootstrap();
            String encodedSAMLResponse = request.getParameter("SAMLResponse");
            String relayState = request.getParameter("RelayState");
            Response samlResponse = MoSAMLUtils.decodeResponse(encodedSAMLResponse);
            if (!StringUtils.equals((CharSequence)samlResponse.getStatus().getStatusCode().getValue(), (CharSequence)"urn:oasis:names:tc:SAML:2.0:status:Success")) {
                String message;
                LOGGER.error("Invalid SAML response. SAML Status Code received: " + samlResponse.getStatus().getStatusCode().getValue());
                if (samlResponse.getStatus().getStatusMessage() != null) {
                    LOGGER.error("Saml Status Message received: " + samlResponse.getStatus().getStatusMessage().getMessage());
                    message = samlResponse.getStatus().getStatusMessage().getMessage() + ". Status Code received in SAML response: " + samlResponse.getStatus().getStatusCode().getValue().split(":")[7];
                } else {
                    message = "Invalid status code \"" + samlResponse.getStatus().getStatusCode().getValue().split(":")[7] + "\" received in SAML response";
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)samlResponse.getStatus().getStatusCode().getValue().split(":")[7], (CharSequence)"urn:oasis:names:tc:SAML:2.0:status:Responder")) {
                    LOGGER.error(message);
                    throw new MoSAMLException(message, MoSAMLException.SAMLErrorCode.RESPONDER);
                }
                LOGGER.error(message);
                throw new MoSAMLException(message, MoSAMLException.SAMLErrorCode.INVALID_SAML_STATUS);
            }
            Assertion assertion = null;
            if (samlResponse.getAssertions() == null || samlResponse.getAssertions().isEmpty()) {
                LOGGER.debug("Free version does not support encrypted SAML assertion. Please contact to info@xecurify.com to upgrade plugin.");
                throw new MoSAMLException("Free version does not support Encrypted assertion", MoSAMLException.SAMLErrorCode.ENCRYPTED_ASSERTION);
            }
            LOGGER.debug("SAML Response is not Encrypted...");
            assertion = (Assertion)samlResponse.getAssertions().get(0);
            this.verifyConditions(assertion, settings.getSpEntityId());
            String acs = settings.getAcsUrl();
            String idpACS = acs + "?idp=";
            this.verifyIssuer(samlResponse, assertion, settings.getIdpEntityId());
            this.verifyDestination(samlResponse, acs, idpACS);
            this.verifyRecipient(assertion, acs, idpACS);
            MoSAMLException t = null;
            Boolean verified = Boolean.FALSE;
            try {
                verified = this.verifyCertificate(samlResponse, assertion, settings.getX509Certificate());
            }
            catch (MoSAMLException e) {
                t = e;
            }
            if (!verified.booleanValue() && t != null) {
                LOGGER.error(t.getMessage(), (Throwable)t);
                throw t;
            }
            Map<String, String[]> attributes = this.getAttributes(assertion);
            NameID nameId = assertion.getSubject().getNameID();
            String nameIdValue = "";
            String sessionIndex = ((AuthnStatement)assertion.getAuthnStatements().get(0)).getSessionIndex();
            LOGGER.debug("session index is : " + sessionIndex);
            if (nameId != null) {
                nameIdValue = nameId.getValue();
            }
            LOGGER.debug("Name id value is :" + nameIdValue);
            attributes.put("NameID", new String[]{nameIdValue});
            return new MoSAMLResponse(attributes, nameIdValue, sessionIndex, relayState);
        }
        catch (MoSAMLException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while verifying the SAML Response.", (Throwable)e);
            throw new MoSAMLException(e, MoSAMLException.SAMLErrorCode.UNKNOWN);
        }
    }

    public long timeInMiliseconds() {
        String time = "0";
        LOGGER.debug("Time is: " + time);
        long timeDelay = Long.parseLong(time);
        timeDelay = timeDelay * 60L * 1000L;
        return timeDelay;
    }

    private void verifyConditions(Assertion assertion, String audienceExpected) {
        long timediff;
        LOGGER.debug("Verifying Conditions...");
        Date now = new DateTime().toDate();
        Date notBefore = null;
        Date notOnOrAfter = null;
        long timeDifferenceInBefore = 0L;
        long timeDifferenceInAfter = 0L;
        if (assertion.getConditions().getNotBefore() != null) {
            notBefore = assertion.getConditions().getNotBefore().toDate();
            if (now.before(notBefore)) {
                timeDifferenceInBefore = Math.abs(notBefore.getTime() - now.getTime());
            }
            LOGGER.debug("timeDifferenceInBefore = " + timeDifferenceInBefore);
        }
        if (assertion.getConditions().getNotOnOrAfter() != null) {
            notOnOrAfter = assertion.getConditions().getNotOnOrAfter().toDate();
            if (now.after(notOnOrAfter)) {
                timeDifferenceInAfter = Math.abs(now.getTime() - notOnOrAfter.getTime());
            }
            LOGGER.debug("timeDifferenceInAfter = " + timeDifferenceInAfter);
        }
        long userAddeddelay = this.timeInMiliseconds();
        long timediff1 = userAddeddelay - timeDifferenceInBefore;
        long timediff2 = userAddeddelay - timeDifferenceInAfter;
        if (timediff1 != 0L) {
            timediff = -timediff1;
            this.replacement = "Forward";
        } else {
            timediff = -timediff2;
            this.replacement = "Back";
        }
        long valueinminutes = timediff / 60000L % 60L;
        long exactvalueinminutes = Math.incrementExact(valueinminutes);
        if (notBefore != null && now.before(notBefore) && userAddeddelay - timeDifferenceInBefore < 0L) {
            this.throwSamlException(exactvalueinminutes);
        } else if (notOnOrAfter != null && (now.after(notOnOrAfter) || now.equals(notOnOrAfter)) && userAddeddelay - timeDifferenceInAfter < 0L) {
            this.throwSamlException(exactvalueinminutes);
        }
        List audiencesInAssertion = ((AudienceRestriction)assertion.getConditions().getAudienceRestrictions().get(0)).getAudiences();
        for (Audience audience : audiencesInAssertion) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)audience.getAudienceURI(), (CharSequence)audienceExpected)) continue;
            return;
        }
        MoSAMLException e = new MoSAMLException(MoSAMLException.SAMLErrorCode.INVALID_AUDIENCE);
        LOGGER.error(MoSAMLException.SAMLErrorCode.INVALID_AUDIENCE.getMessage(), (Throwable)e);
        throw e;
    }

    private void throwSamlException(long exactvalueinminutes) {
        MoSAMLException.SAMLErrorCode errorCode = MoSAMLException.SAMLErrorCode.INVALID_CONDITIONS;
        MoSAMLException samlexception = new MoSAMLException(errorCode.getMessage(), this.timeDiff(errorCode, exactvalueinminutes), errorCode);
        LOGGER.error(samlexception.getMessage(), (Throwable)samlexception);
        throw samlexception;
    }

    private String timeDiff(MoSAMLException.SAMLErrorCode error, long temp) {
        StringBuilder errorMsg = new StringBuilder(error.getResolution());
        errorMsg.append(" Set your Server clock " + this.replacement + " by ");
        errorMsg.append(temp);
        errorMsg.append(" minutes  Or you can Increase ");
        errorMsg.append(temp);
        errorMsg.append(" minutes in  validate Saml Response in SSO setting tab.");
        return errorMsg.toString();
    }

    private void verifyIssuer(Response response, Assertion assertion, String idpEntityId) {
        LOGGER.debug("Verifying Issuer in SAML Response");
        String issuerInResponse = response.getIssuer().getValue();
        String issuerInAssertion = assertion.getIssuer().getValue();
        if (!StringUtils.equals((CharSequence)issuerInResponse, (CharSequence)idpEntityId)) {
            MoSAMLException.SAMLErrorCode errorCode = MoSAMLException.SAMLErrorCode.INVALID_ISSUER;
            MoSAMLException e = new MoSAMLException(errorCode.getMessage(), this.buildResolutionMessage(errorCode, idpEntityId, issuerInResponse), errorCode);
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        if (!StringUtils.equals((CharSequence)issuerInAssertion, (CharSequence)idpEntityId)) {
            MoSAMLException.SAMLErrorCode errorCode = MoSAMLException.SAMLErrorCode.INVALID_ISSUER;
            MoSAMLException e = new MoSAMLException(errorCode.getMessage(), this.buildResolutionMessage(errorCode, idpEntityId, issuerInAssertion), errorCode);
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private void verifyDestination(Response response, String acsUrl, String idpAcsUrl) {
        LOGGER.debug("Verifying Destination if present in SAML Response");
        String destInResponse = response.getDestination();
        if (StringUtils.isBlank((CharSequence)destInResponse) || StringUtils.equals((CharSequence)destInResponse, (CharSequence)acsUrl) || StringUtils.equals((CharSequence)destInResponse, (CharSequence)idpAcsUrl)) {
            return;
        }
        MoSAMLException.SAMLErrorCode errorCode = MoSAMLException.SAMLErrorCode.INVALID_DESTINATION;
        MoSAMLException e = new MoSAMLException(errorCode.getMessage(), this.buildResolutionMessage(errorCode, acsUrl, destInResponse), errorCode);
        LOGGER.error(e.getMessage(), (Throwable)e);
        throw e;
    }

    private void verifyRecipient(Assertion assertion, String acsUrl, String idpAcsUrl) {
        LOGGER.debug("Verifying Recipient if present in SAML Response");
        String recipientInResponse = ((SubjectConfirmation)assertion.getSubject().getSubjectConfirmations().get(0)).getSubjectConfirmationData().getRecipient();
        if (StringUtils.isBlank((CharSequence)recipientInResponse) || StringUtils.equals((CharSequence)recipientInResponse, (CharSequence)acsUrl) || StringUtils.equals((CharSequence)recipientInResponse, (CharSequence)idpAcsUrl)) {
            return;
        }
        MoSAMLException.SAMLErrorCode errorCode = MoSAMLException.SAMLErrorCode.INVALID_RECIPIENT;
        MoSAMLException e = new MoSAMLException(errorCode.getMessage(), this.buildResolutionMessage(errorCode, acsUrl, recipientInResponse), errorCode);
        LOGGER.error(e.getMessage(), (Throwable)e);
        throw e;
    }

    private String buildResolutionMessage(MoSAMLException.SAMLErrorCode error, String found, String expected) {
        StringBuilder errorMsg = new StringBuilder(error.getResolution());
        errorMsg.append(" Connector was expecting ");
        errorMsg.append(expected);
        errorMsg.append(" but found: ");
        errorMsg.append(found);
        return errorMsg.toString();
    }

    private Boolean verifyCertificate(Response response, Assertion assertion, String x509Certificate) {
        LOGGER.debug("Verifying Certificates.");
        if (x509Certificate != null) {
            try {
                if (!response.isSigned() && !assertion.isSigned()) {
                    MoSAMLException e = new MoSAMLException(MoSAMLException.SAMLErrorCode.ASSERTION_NOT_SIGNED);
                    LOGGER.error(MoSAMLException.SAMLErrorCode.ASSERTION_NOT_SIGNED.getMessage(), (Throwable)e);
                    throw e;
                }
                if (response.isSigned()) {
                    return MoSAMLUtils.verifyCertificate((SignableXMLObject)response, x509Certificate);
                }
                if (assertion.isSigned()) {
                    return MoSAMLUtils.verifyCertificate((SignableXMLObject)assertion, x509Certificate);
                }
                LOGGER.error("Error occured while verifing the certificate");
            }
            catch (NoSuchAlgorithmException | CertificateException e) {
                MoSAMLException.SAMLErrorCode errorCode = MoSAMLException.SAMLErrorCode.INVALID_CERTIFICATE;
                MoSAMLException samlexception = new MoSAMLException(errorCode.getMessage(), this.buildResolutionforcertificate(errorCode, assertion, response), errorCode);
                LOGGER.error(samlexception.getMessage(), (Throwable)e);
                throw samlexception;
            }
            catch (ValidationException e) {
                MoSAMLException.SAMLErrorCode errorCode = MoSAMLException.SAMLErrorCode.INVALID_SIGNATURE;
                MoSAMLException samlexception = new MoSAMLException(errorCode.getMessage(), this.buildResolutionforcertificate(errorCode, assertion, response), errorCode);
                LOGGER.error(samlexception.getMessage(), (Throwable)e);
                throw samlexception;
            }
            catch (InvalidKeySpecException e) {
                MoSAMLException.SAMLErrorCode errorCode = MoSAMLException.SAMLErrorCode.INVALID_CERTIFICATE;
                MoSAMLException samlexception = new MoSAMLException(errorCode.getMessage(), this.buildResolutionforcertificate(errorCode, assertion, response), errorCode);
                LOGGER.error(samlexception.getMessage(), (Throwable)e);
                throw samlexception;
            }
        }
        return false;
    }

    private String buildResolutionforcertificate(MoSAMLException.SAMLErrorCode error, Assertion assertion, Response response) {
        List x509Datas;
        if (assertion.isSigned()) {
            x509Datas = assertion.getSignature().getKeyInfo().getX509Datas();
            for (X509Data x509Data : x509Datas) {
                List certificates = x509Data.getX509Certificates();
                for (X509Certificate certificate : certificates) {
                    this.certificateExpected = certificate.getValue();
                }
            }
        } else if (response.isSigned()) {
            x509Datas = response.getSignature().getKeyInfo().getX509Datas();
            for (X509Data x509Data : x509Datas) {
                List certificates = x509Data.getX509Certificates();
                for (X509Certificate certificate : certificates) {
                    this.certificateExpected = certificate.getValue();
                }
            }
        }
        StringBuilder errorMsg = new StringBuilder(error.getResolution());
        errorMsg.append(" Expected certificate : ");
        errorMsg.append("<textarea rows='6' cols='100' word-wrap='break-word;' style='width:580px; margin:0px; height:290px;' id ='errormsg' readonly>-----BEGIN CERTIFICATE-----" + this.certificateExpected + "-----END CERTIFICATE-----</textarea> ");
        return errorMsg.toString();
    }

    private Map<String, String[]> getAttributes(Assertion assertion) {
        LOGGER.debug("Getting attributes from SAML Response");
        HashMap<String, String[]> attributes = new HashMap<String, String[]>();
        if (!assertion.getAttributeStatements().isEmpty()) {
            for (Attribute attr : ((AttributeStatement)assertion.getAttributeStatements().get(0)).getAttributes()) {
                if (attr.getAttributeValues().isEmpty()) continue;
                String[] values = new String[attr.getAttributeValues().size()];
                for (int i = 0; i < attr.getAttributeValues().size(); ++i) {
                    values[i] = ((XMLObject)attr.getAttributeValues().get(i)).getDOM().getTextContent();
                }
                attributes.put(attr.getName(), values);
            }
        }
        return attributes;
    }
}

