/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.app.helpers;

import com.miniorange.app.helpers.MoSAMLSettings;
import com.miniorange.app.helpers.MoSAMLUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

public class MoSAMLSPMeta {
    static MoSAMLSettings settings = new MoSAMLSettings();
    public static final Logger LOGGER = Loggers.get(MoSAMLSPMeta.class);

    private MoSAMLSPMeta() {
    }

    public static void initializeMetadata(HttpServletResponse response, HttpServletRequest request, String returnWith) {
        try {
            PrintWriter out = response.getWriter();
            LOGGER.debug("return to parameter :" + returnWith);
            response.setContentType("text/html");
            String redirectUrl = "/sessions/init/miniorangesamlplugin?RelayState=init_spmeta";
            if (!settings.getSonarQubeContextPath().equals("NOT_SPECIFIED")) {
                redirectUrl = settings.getSonarQubeContextPath() + redirectUrl;
            }
            out.print("<html><body><script>document.write(\"<h2>Please Wait...</h2>\");document.write(\"<form method='post' action='" + redirectUrl + "'  id='mospfrm'>\");document.write(\"<input type='hidden' value='\"+window.location.origin+\"' name='moautosbmttxt' readonly>\");document.write(\"<input type='hidden' value='" + returnWith + "' name='returnWith' readonly></form>\");var frm = document.getElementById(\"mospfrm\");frm.submit();</script></body></html>");
            out.close();
            return;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return;
        }
    }

    public static void generateSPMeta(HttpServletResponse response, HttpServletRequest request) {
        MoSAMLSettings settings = new MoSAMLSettings();
        LOGGER.debug("Generating SP Metadata");
        String baseUrl = request.getParameter("moautosbmttxt");
        String returnTo = request.getParameter("returnWith");
        baseUrl = StringUtils.stripEnd((String)baseUrl, (String)"/");
        if (!settings.getSonarQubeContextPath().equals("NOT_SPECIFIED")) {
            baseUrl = baseUrl + settings.getSonarQubeContextPath();
        }
        settings.setSpBaseUrl(baseUrl);
        String acsURL = baseUrl + "/oauth2/callback/miniorangesamlplugin";
        settings.setAcsUrl(acsURL);
        String spEntityID = baseUrl + "/sonar_saml_auth";
        settings.setSpEntityId(spEntityID);
        try {
            response.sendRedirect(baseUrl + "/sessions/init/miniorangesamlplugin?RelayState=" + returnTo);
        }
        catch (IOException e) {
            LOGGER.debug(e.getMessage());
        }
    }

    public static void showMetadata(HttpServletResponse response, HttpServletRequest request) {
        LOGGER.debug("Rendering Metadata ");
        try {
            String metadata = IOUtils.toString((InputStream)MoSAMLUtils.class.getResourceAsStream("/metadata-template.xml"), (Charset)StandardCharsets.UTF_8);
            String baseUrl = settings.getSpBaseUrl();
            String certificate = settings.getPublicSPCertificate();
            certificate = MoSAMLUtils.deserializePublicCertificate(certificate);
            metadata = StringUtils.replace((String)metadata, (String)"##SP_ENTITY_ID##", (String)settings.getSpEntityId(), (int)1);
            metadata = StringUtils.replace((String)metadata, (String)"##ACS_URL##", (String)settings.getAcsUrl(), (int)1);
            metadata = StringUtils.replace((String)metadata, (String)"##SIGNING_CERT##", (String)certificate, (int)1);
            metadata = StringUtils.replace((String)metadata, (String)"##ENCRYPTION_CERT##", (String)certificate, (int)1);
            response.setContentType("text/html");
            PrintWriter out = response.getWriter();
            out.println("<!DOCTYPE html><html><head><title>SP Metadata</title><style type=\"text/css\">textarea{ resize : none; }body{ font-family : 'Helvetica Neue',Helvetica,Arial,sans-serif;font-weight : bold; font-size : 14px; color : #444;line-height : 1.42857143;}label{ margin : 10px; }.txt-control {color : #555;margin : 10px;width : 220px;display : float;font-size : 14px;padding : 2px 8px;border-radius : 4px;border : 1px solid #ccc;background-color : #fff;line-height : 1.42857143;}.btn, button, input[type=button], input[type=submit] {margin : 10px;height : 24px;outline : none;color : #236a97;cursor : pointer;font-size : 12px;padding : 0 12px;font-weight : 600;line-height : 22px;border-radius : 2px;text-align : center;text-decoration : none;display : inline-block;box-sizing : border-box;background : transparent;vertical-align : baseline;border : 1px solid #236a97;transition : border-color .2s ease;}.btn:hover, button:hover, a:hover{color : white;background : #236a97;}</style></head>");
            out.println("<body><div style=\"padding:10px; margin:40px 10px;\"><label>1. Provide SP Metadata as:  </label><input type='radio' name='format' id='file' onchange=\"alterHiddenFunction('file','fileformat','txtformat')\" checked><label for='file'>XML File</label> &nbsp&nbsp&nbsp&nbsp&nbsp<input type='radio' name='format' id='txt' onchange=\"alterHiddenFunction('txt','txtformat','fileformat')\"><label for='txt'>XML Text</label><br><table align='center'>");
            out.println("<tr><td colspan='4' id='txtformat' hidden><label>Text Format</label><input type='button' class='btn' style=\"margin-left:95px;\" id='txtformatbtn' value='Copy' onclick=\"copyTextFunction('txtfrmtarea','txtformatbtn')\" ><br/><textarea style='width:480px' class='txt-control' id='txtfrmtarea' rows='5' readonly>" + metadata + "</textarea></td></tr>");
            out.println("<tr><td colspan='4' id='fileformat'><center><a class='btn' target='_parent' href='" + baseUrl + "/sessions/init/miniorangesamlplugin?RelayState=download_metadata' download> Download Metadata File</a></center></td></tr></table><br> <center><b>OR</b></center><br>");
            out.println("<label>2. Provide SP Details Manually: </label><br><table align='center'><tr><td><label>SP Entity ID :</label></td><td><input type='button' class='btn' id='spidbtn' value='Copy' onclick=\"copyTextFunction('spidtxt','spidbtn')\"><br/></td><td><label> ACS URL :</label></td><td><input type='button' class='btn' id='acsbtn' value='Copy' onclick=\"copyTextFunction('acstxt','acsbtn')\"><br/></td></tr>");
            out.println("<tr><td colspan='2'><input type='text' class='txt-control' id='spidtxt' value='" + settings.getSpEntityId() + "' readonly><br/><br/></td><td colspan='2'><input type='text' class='txt-control' id='acstxt' value='" + settings.getAcsUrl() + "' readonly><br/><br/></td></tr>");
            out.println("<tr><td><label> Signing Certificate :</label></td><td><input type='button' class='btn' id='certbtn' value='Copy' onclick=\"copyTextFunction('certtxt','certbtn')\"></td><td><a class='btn' style=\"margin-left:20px;\" href='" + baseUrl + "/sessions/init/miniorangesamlplugin?RelayState=download_certificate' download>Download Certificate</a><br/></td></tr>");
            out.println("<tr><td colspan='4'><textarea id='certtxt' class='txt-control' style=\"width:480px\" rows='4' readonly>-----BEGIN CERTIFICATE-----" + certificate + "-----END CERTIFICATE-----</textarea></td></tr>");
            out.println("</table>");
            out.println("</div><script>function copyTextFunction(txtid, btnid) {var copyText = document.getElementById(txtid);copyText.select();copyText.setSelectionRange(0, 99999);document.execCommand(\"copy\");document.getElementById(btnid).value = \"Copied\";}");
            out.println("function alterHiddenFunction(radioid,format1,format2){var v = document.getElementById(radioid);if(v.id==\"txt\"){document.getElementById(format1).hidden=false;document.getElementById(format2).hidden=true;}else if(v.id==\"file\"){document.getElementById(format1).hidden=false;document.getElementById(format2).hidden=true;}v.scrollIntoView();}");
            out.println("</script></body></html>");
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
    }

    public static void downloadMetadata(HttpServletResponse response, HttpServletRequest request) {
        LOGGER.debug("SP Metadata downloading...");
        try {
            String metadata = IOUtils.toString((InputStream)MoSAMLUtils.class.getResourceAsStream("/metadata-template.xml"), (Charset)StandardCharsets.UTF_8);
            String certificate = settings.getPublicSPCertificate();
            certificate = MoSAMLUtils.deserializePublicCertificate(certificate);
            metadata = StringUtils.replace((String)metadata, (String)"##SP_ENTITY_ID##", (String)settings.getSpEntityId(), (int)1);
            metadata = StringUtils.replace((String)metadata, (String)"##ACS_URL##", (String)settings.getAcsUrl(), (int)1);
            metadata = StringUtils.replace((String)metadata, (String)"##SIGNING_CERT##", (String)certificate, (int)1);
            metadata = StringUtils.replace((String)metadata, (String)"##ENCRYPTION_CERT##", (String)certificate, (int)1);
            response.setContentType("text/xml");
            response.getOutputStream().write(metadata.getBytes());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
    }

    public static void downloadCertificate(HttpServletResponse response) {
        LOGGER.debug("SP Certificate downloading...");
        try {
            String cert = IOUtils.toString((InputStream)MoSAMLUtils.class.getResourceAsStream("/certificates/new-sp-certificate.crt"), (Charset)StandardCharsets.UTF_8);
            response.setContentType("text/txt");
            response.getOutputStream().write(cert.getBytes());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
    }
}

