/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.app.helpers;

import com.miniorange.app.helpers.MoSAMLUtils;
import com.miniorange.saml.MiniorangeSamlProperties;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

public class MoSAMLSettings {
    private final String CUSTOMER_TOKEN_KEY = MoSAMLSettings.generateRandomAlphaNumericKey(16);
    private static Logger LOGGER = Loggers.get(MoSAMLSettings.class);
    private static boolean isSPBaseURLSet = false;
    private static final String PUBLIC_CERT_PATH = "/certificates/new-sp-certificate.crt";
    private static final String PRIVATE_CERT_PATH = "/certificates/new-sp-key.key";
    private static final String CONFIG_FILE_PATH = "/config.properties";
    private static String publicCertificate;
    private static String privateCertificate;
    static Properties properties;

    public Boolean isEnabled() {
        Boolean value = MiniorangeSamlProperties.getConfiguration().getBoolean("mo.saml.enable").orElse(false);
        LOGGER.debug("miniOrangeSAML Auth enabled : " + value);
        return value;
    }

    public Boolean allowSignUp() {
        Boolean value = MiniorangeSamlProperties.getConfiguration().getBoolean("mo.saml.sign_up").orElse(false);
        LOGGER.debug("Allow Sign Up : " + value);
        return value;
    }

    public String getIdpName() {
        String value = MiniorangeSamlProperties.getConfiguration().get("mo.saml.idp_name").orElse("Undefined Name");
        LOGGER.debug("Getting IDP NAME : " + value);
        return value;
    }

    public String getIdpEntityId() {
        String value = MiniorangeSamlProperties.getConfiguration().get("mo.saml.idp_entity_id").orElse("IDP ISSUER MISSING");
        LOGGER.debug("Getting IDP ISSUER : " + value);
        return value;
    }

    public String getSamlLoginUrl() {
        String value = MiniorangeSamlProperties.getConfiguration().get("mo.saml.idp_login_url").orElse("LOGIN URL MISSING");
        LOGGER.debug("Getting LOGIN URL : " + value);
        return value;
    }

    public String getSamlLoginBindingType() {
        String value = MiniorangeSamlProperties.getConfiguration().get("mo.saml.bind_type").orElse("DEFAULT BIND TYPE");
        LOGGER.debug("Getting BIND TYPE : " + value);
        return value;
    }

    public String getSonarQubeContextPath() {
        String value = MiniorangeSamlProperties.getConfiguration().get("sonar.web.context").orElse("NOT_SPECIFIED");
        if (!value.equals("NOT_SPECIFIED")) {
            value = StringUtils.stripEnd((String)value, (String)"/");
        }
        return value;
    }

    public String getX509Certificate() {
        String value = MiniorangeSamlProperties.getConfiguration().get("mo.saml.idp_x509").orElse("EMPTY OR INVALID CERTIFICATE");
        LOGGER.debug("Getting X509 CERTIFICATE : " + value);
        return value;
    }

    public String getNameIDFormat() {
        return properties.getProperty("nameIDFormat");
    }

    public String getSpBaseUrl() {
        return properties.getProperty("spBaseUrl");
    }

    public String getSpEntityId() {
        return properties.getProperty("spEntityId");
    }

    public String getAcsUrl() {
        return properties.getProperty("acsUrl");
    }

    public String getPublicSPCertificate() {
        return publicCertificate;
    }

    public String getPrivateSPCertificate() {
        return privateCertificate;
    }

    public void setSpBaseUrl(String value) {
        properties.setProperty("spBaseUrl", value);
        isSPBaseURLSet = true;
    }

    public void setAcsUrl(String value) {
        properties.setProperty("acsUrl", value);
    }

    public void setSpEntityId(String value) {
        properties.setProperty("spEntityId", value);
    }

    public boolean isSPBaseURLSet() {
        return isSPBaseURLSet;
    }

    public String getLoginAttr() {
        String value = MiniorangeSamlProperties.getConfiguration().get("mo.saml.login_attr").orElse("NameID");
        LOGGER.debug("Getting LOGIN ATTRIBUTE : " + value);
        return value;
    }

    public String getNameAttr() {
        String value = MiniorangeSamlProperties.getConfiguration().get("mo.saml.name_attr").orElse("EMPTY NAME ATTRIBUTE");
        LOGGER.debug("Getting NAME ATTRIBUTE : " + value);
        return value;
    }

    public String getCustomLogoutURL() {
        return "";
    }

    public String getApplicationUrl() {
        return properties.getProperty("applicationUrl");
    }

    public String getSAMLHandlerUrl() {
        return properties.getProperty("SAMLHandlerUrl");
    }

    public String getBase64EncodedKey() {
        return properties.getProperty("jwtKey");
    }

    public String getSonarQubeVersion() {
        return MiniorangeSamlProperties.getConfiguration().get("mo.saml.sonarqube_version").orElse("Not Available");
    }

    public static String generateRandomAlphaNumericKey(int bytes) {
        return RandomStringUtils.random((int)bytes, (boolean)true, (boolean)true);
    }

    static {
        properties = new Properties();
        try {
            publicCertificate = IOUtils.toString((InputStream)MoSAMLSettings.class.getResourceAsStream(PUBLIC_CERT_PATH), (Charset)StandardCharsets.UTF_8);
            publicCertificate = MoSAMLUtils.serializePublicCertificate(publicCertificate);
            privateCertificate = IOUtils.toString((InputStream)MoSAMLSettings.class.getResourceAsStream(PRIVATE_CERT_PATH), (Charset)StandardCharsets.UTF_8);
            privateCertificate = MoSAMLUtils.serializePrivateCertificate(privateCertificate);
            properties.load(MoSAMLSettings.class.getResourceAsStream(CONFIG_FILE_PATH));
        }
        catch (IOException e) {
            LOGGER.error("An I/O error occurred while initializing the SAML Settings.", (Throwable)e);
        }
    }
}

