/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.app.helpers;

import com.google.gson.Gson;
import com.miniorange.app.classes.MoSAMLException;
import com.miniorange.app.classes.MoSAMLResponse;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.ProxySelector;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.joda.time.DateTime;
import org.opensaml.Configuration;
import org.opensaml.DefaultBootstrap;
import org.opensaml.common.SAMLVersion;
import org.opensaml.common.SignableSAMLObject;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.NameIDPolicy;
import org.opensaml.saml2.core.Response;
import org.opensaml.saml2.core.Status;
import org.opensaml.saml2.core.StatusCode;
import org.opensaml.saml2.core.impl.AuthnRequestBuilder;
import org.opensaml.saml2.core.impl.IssuerBuilder;
import org.opensaml.saml2.core.impl.NameIDPolicyBuilder;
import org.opensaml.saml2.core.impl.StatusBuilder;
import org.opensaml.saml2.core.impl.StatusCodeBuilder;
import org.opensaml.security.SAMLSignatureProfileValidator;
import org.opensaml.xml.ConfigurationException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallerFactory;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.io.Unmarshaller;
import org.opensaml.xml.io.UnmarshallerFactory;
import org.opensaml.xml.io.UnmarshallingException;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.keyinfo.KeyInfoGeneratorFactory;
import org.opensaml.xml.security.keyinfo.KeyInfoGeneratorManager;
import org.opensaml.xml.security.x509.BasicX509Credential;
import org.opensaml.xml.signature.KeyInfo;
import org.opensaml.xml.signature.SignableXMLObject;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.SignatureException;
import org.opensaml.xml.signature.SignatureValidator;
import org.opensaml.xml.signature.Signer;
import org.opensaml.xml.util.XMLHelper;
import org.opensaml.xml.validation.ValidationException;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class MoSAMLUtils {
    public static final String SAML_REQUEST_PARAM = "SAMLRequest";
    public static final String RELAY_STATE_PARAM = "RelayState";
    public static final String SIGNATURE_ALGO_PARAM = "SigAlg";
    public static final String SIGNATURE_PARAM = "Signature";
    public static final String SAML_RESPONSE_PARAM = "SAMLResponse";
    private static final String ENCRYPTION_ALGORITHM = "AES";
    public static final Logger LOGGER = Loggers.get(MoSAMLUtils.class);
    private static final String NAMESPACE_PREFIX = "samlp";
    private static boolean bootstrap = false;

    private MoSAMLUtils() {
    }

    public static void doBootstrap() {
        if (!bootstrap) {
            try {
                LOGGER.debug("Setting bootstrap enabled");
                bootstrap = true;
                DefaultBootstrap.bootstrap();
            }
            catch (ConfigurationException e) {
                LOGGER.error(e.getMessage());
            }
        }
    }

    public static AuthnRequest buildAuthnRequest(String issuer, String acsUrl, String destination, String nameIdFormat) {
        LOGGER.debug("Building Authentication Request");
        AuthnRequest authnRequest = new AuthnRequestBuilder().buildObject("urn:oasis:names:tc:SAML:2.0:protocol", "AuthnRequest", NAMESPACE_PREFIX);
        DateTime issueInstant = new DateTime();
        authnRequest.setID(MoSAMLUtils.generateRandomString());
        authnRequest.setVersion(SAMLVersion.VERSION_20);
        authnRequest.setIssueInstant(issueInstant);
        authnRequest.setProtocolBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        authnRequest.setIssuer(MoSAMLUtils.buildIssuer(issuer));
        authnRequest.setAssertionConsumerServiceURL(acsUrl);
        authnRequest.setDestination(destination);
        NameIDPolicyBuilder nameIdPolicyBuilder = new NameIDPolicyBuilder();
        NameIDPolicy nameIdPolicy = nameIdPolicyBuilder.buildObject();
        nameIdPolicy.setFormat(nameIdFormat);
        nameIdPolicy.setAllowCreate(Boolean.valueOf(true));
        authnRequest.setNameIDPolicy(nameIdPolicy);
        return authnRequest;
    }

    public static SignableSAMLObject signHttpPostRequest(SignableSAMLObject request, String pubicKey, String privateKey) throws CertificateException, InvalidKeySpecException, NoSuchAlgorithmException, SecurityException, MarshallingException, SignatureException {
        LOGGER.debug("Signing HTTP Post Request. ");
        Signature signature = (Signature)Configuration.getBuilderFactory().getBuilder(Signature.DEFAULT_ELEMENT_NAME).buildObject(Signature.DEFAULT_ELEMENT_NAME);
        Credential credential = MoSAMLUtils.getCredential(pubicKey, privateKey);
        signature.setSigningCredential(credential);
        signature.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        KeyInfoGeneratorManager keyInfoGeneratorManager = Configuration.getGlobalSecurityConfiguration().getKeyInfoGeneratorManager().getDefaultManager();
        KeyInfoGeneratorFactory keyInfoGeneratorFactory = keyInfoGeneratorManager.getFactory(credential);
        KeyInfo keyInfo = keyInfoGeneratorFactory.newInstance().generate(credential);
        signature.setKeyInfo(keyInfo);
        String signatureAlgo = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
        signature.setSignatureAlgorithm(signatureAlgo);
        request.setSignature(signature);
        MarshallerFactory marshallerFactory = Configuration.getMarshallerFactory();
        Marshaller marshaller = marshallerFactory.getMarshaller((XMLObject)request);
        marshaller.marshall((XMLObject)request);
        Signer.signObject((Signature)signature);
        return request;
    }

    public static String signHttpRedirectRequest(String requestQueryString, String sigAlgo, String pubicKey, String privateKey) throws UnsupportedEncodingException, NoSuchAlgorithmException, CertificateException, InvalidKeySpecException, InvalidKeyException, java.security.SignatureException {
        LOGGER.debug("Signig Http Redirect Request called ");
        String signatureBase64encodedString = "";
        StringBuilder builder = new StringBuilder(requestQueryString);
        builder.append("&").append(SIGNATURE_ALGO_PARAM).append("=").append(URLEncoder.encode(sigAlgo, "UTF-8"));
        java.security.Signature signature = java.security.Signature.getInstance("SHA256withRSA");
        Credential credentials = MoSAMLUtils.getCredential(pubicKey, privateKey);
        signature.initSign(credentials.getPrivateKey());
        signature.update(builder.toString().getBytes());
        byte[] signatureByteArray = signature.sign();
        signatureBase64encodedString = org.opensaml.xml.util.Base64.encodeBytes((byte[])signatureByteArray);
        return signatureBase64encodedString;
    }

    public static String base64EncodeRequest(XMLObject request, Boolean isHttpPostBinding) throws MarshallingException, IOException {
        LOGGER.debug("Encoding Sign Request with Base64 encoder.");
        String encodedRequestMessage = "";
        Marshaller marshaller = Configuration.getMarshallerFactory().getMarshaller(request);
        Element authDOM = marshaller.marshall(request);
        StringWriter requestWriter = new StringWriter();
        XMLHelper.writeNode((Node)authDOM, (Writer)requestWriter);
        String requestMessage = requestWriter.toString();
        if (isHttpPostBinding.booleanValue()) {
            return org.opensaml.xml.util.Base64.encodeBytes((byte[])requestMessage.getBytes(StandardCharsets.UTF_8), (int)8);
        }
        Deflater deflater = new Deflater(-1, true);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)byteArrayOutputStream, deflater);
        deflaterOutputStream.write(requestMessage.getBytes(StandardCharsets.UTF_8));
        deflaterOutputStream.close();
        byteArrayOutputStream.close();
        encodedRequestMessage = org.opensaml.xml.util.Base64.encodeBytes((byte[])byteArrayOutputStream.toByteArray(), (int)8);
        return encodedRequestMessage;
    }

    private static Credential getCredential(String publicKey, String privateKeyStr) throws CertificateException, InvalidKeySpecException, NoSuchAlgorithmException {
        publicKey = MoSAMLUtils.serializePublicCertificate(publicKey);
        ByteArrayInputStream is = new ByteArrayInputStream(publicKey.getBytes());
        CertificateFactory cf = CertificateFactory.getInstance("X509");
        X509Certificate cert = (X509Certificate)cf.generateCertificate(is);
        BasicX509Credential x509Credential = new BasicX509Credential();
        x509Credential.setPublicKey(cert.getPublicKey());
        PrivateKey privateKey = MoSAMLUtils.getPrivateKey(privateKeyStr);
        if (privateKey != null) {
            x509Credential.setPrivateKey(privateKey);
        }
        BasicX509Credential credential = x509Credential;
        LOGGER.debug("credential = " + credential);
        return credential;
    }

    private static Issuer buildIssuer(String issuerValue) {
        LOGGER.debug("Building Issuer");
        Issuer issuer = new IssuerBuilder().buildObject("urn:oasis:names:tc:SAML:2.0:assertion", "Issuer", "saml");
        issuer.setValue(issuerValue);
        return issuer;
    }

    public static String generateRandomString() {
        String uuid = UUID.randomUUID().toString();
        return "_" + StringUtils.remove((String)uuid, (char)'-');
    }

    public static String serializePublicCertificate(String certificate) {
        LOGGER.debug("Serializing Public Certificate");
        String BEGIN_CERTIFICATE = "BEGIN CERTIFICATE";
        String END_CERTIFICATE = "END CERTIFICATE";
        if (StringUtils.isNotBlank((CharSequence)certificate)) {
            certificate = StringUtils.remove((String)certificate, (String)"\r");
            certificate = StringUtils.remove((String)certificate, (String)"\n");
            certificate = StringUtils.remove((String)certificate, (String)"-");
            certificate = StringUtils.remove((String)certificate, (String)BEGIN_CERTIFICATE);
            certificate = StringUtils.remove((String)certificate, (String)END_CERTIFICATE);
            certificate = StringUtils.remove((String)certificate, (String)" ");
            Base64 encoder = new Base64(64);
            certificate = encoder.encodeToString(Base64.decodeBase64((String)certificate));
            StringBuilder cert = new StringBuilder("-----" + BEGIN_CERTIFICATE + "-----\r\n");
            cert.append(certificate);
            cert.append("-----" + END_CERTIFICATE + "-----");
            return cert.toString();
        }
        return certificate;
    }

    public static String serializePrivateCertificate(String certificate) {
        LOGGER.debug("Serializing Private Certificate");
        String BEGIN_CERTIFICATE = "BEGIN PRIVATE KEY";
        String END_CERTIFICATE = "END PRIVATE KEY";
        if (StringUtils.isNotBlank((CharSequence)certificate)) {
            certificate = StringUtils.remove((String)certificate, (String)"\r");
            certificate = StringUtils.remove((String)certificate, (String)"\n");
            certificate = StringUtils.remove((String)certificate, (String)"-");
            certificate = StringUtils.remove((String)certificate, (String)BEGIN_CERTIFICATE);
            certificate = StringUtils.remove((String)certificate, (String)END_CERTIFICATE);
            certificate = StringUtils.remove((String)certificate, (String)" ");
            Base64 encoder = new Base64(64);
            certificate = encoder.encodeToString(Base64.decodeBase64((String)certificate));
            StringBuilder cert = new StringBuilder("-----" + BEGIN_CERTIFICATE + "-----\r\n");
            cert.append(certificate);
            cert.append("-----" + END_CERTIFICATE + "-----");
            return cert.toString();
        }
        return certificate;
    }

    public static String deserializePublicCertificate(String certificate) {
        LOGGER.debug("Deserializing Public Certificate");
        String BEGIN_CERTIFICATE = "BEGIN CERTIFICATE";
        String END_CERTIFICATE = "END CERTIFICATE";
        if (StringUtils.isNotBlank((CharSequence)certificate)) {
            certificate = StringUtils.remove((String)certificate, (String)"\r");
            certificate = StringUtils.remove((String)certificate, (String)"\n");
            certificate = StringUtils.remove((String)certificate, (String)"-");
            certificate = StringUtils.remove((String)certificate, (String)BEGIN_CERTIFICATE);
            certificate = StringUtils.remove((String)certificate, (String)END_CERTIFICATE);
            certificate = StringUtils.remove((String)certificate, (String)" ");
        }
        return certificate;
    }

    public static String deserializePrivateCertificate(String certificate) {
        LOGGER.debug("Deserializing Private Certificate");
        String BEGIN_CERTIFICATE = "BEGIN PRIVATE KEY";
        String END_CERTIFICATE = "END PRIVATE KEY";
        if (StringUtils.isNotBlank((CharSequence)certificate)) {
            certificate = StringUtils.remove((String)certificate, (String)"\r");
            certificate = StringUtils.remove((String)certificate, (String)"\n");
            certificate = StringUtils.remove((String)certificate, (String)"-");
            certificate = StringUtils.remove((String)certificate, (String)BEGIN_CERTIFICATE);
            certificate = StringUtils.remove((String)certificate, (String)END_CERTIFICATE);
            certificate = StringUtils.remove((String)certificate, (String)" ");
        }
        return certificate;
    }

    private static PrivateKey getPrivateKey(String privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        LOGGER.debug("getPrivateKey called ");
        if (StringUtils.isNotBlank((CharSequence)privateKey)) {
            privateKey = MoSAMLUtils.deserializePrivateCertificate(privateKey);
            byte[] bytes = org.opensaml.xml.util.Base64.decode((String)privateKey);
            PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(bytes);
            KeyFactory kf = KeyFactory.getInstance("RSA");
            return kf.generatePrivate(spec);
        }
        return null;
    }

    public static String htmlEncode(String s) {
        if (StringUtils.isNotBlank((CharSequence)s)) {
            char[] chars;
            StringBuilder encodedString = new StringBuilder("");
            for (char c : chars = s.toCharArray()) {
                if (c == '<') {
                    encodedString.append("&lt;");
                    continue;
                }
                if (c == '>') {
                    encodedString.append("&gt;");
                    continue;
                }
                if (c == '\'') {
                    encodedString.append("&apos;");
                    continue;
                }
                if (c == '\"') {
                    encodedString.append("&quot;");
                    continue;
                }
                if (c == '&') {
                    encodedString.append("&amp;");
                    continue;
                }
                encodedString.append(c);
            }
            return encodedString.toString();
        }
        return "";
    }

    public static String showTestConfigurationResult(MoSAMLResponse moSAMLResponse, MoSAMLException e) {
        LOGGER.debug("showTestConfigurationResult called.");
        if (e == null) {
            String username = "";
            StringBuilder htmlStart = new StringBuilder("<div style=\"font-family:Calibri;padding:0 3%;\">");
            htmlStart = htmlStart.append("<div style=\"color: #3c763d;background-color: #dff0d8; padding:2%;margin-bottom:20px;text-align:center; border:1px solid #AEDB9A; font-size:18pt;\">TEST SUCCESSFUL</div>");
            for (String key : moSAMLResponse.getAttributes().keySet()) {
                if (!key.equalsIgnoreCase("nameid")) continue;
                String[] values = moSAMLResponse.getAttributes().get(key);
                username = values[0];
            }
            htmlStart = htmlStart.append("<span style=\"font-size:14pt;\"><b>Hello</b>, " + username + "</span><br/><p style=\"font-weight:bold;font-size:14pt;margin-left:1%;\">ATTRIBUTES RECEIVED:</p><table style=\"border-collapse:collapse;border-spacing:0; display:table;width:100%; font-size:14pt;background-color:#EDEDED;\"><tr style=\"text-align:center;\"><td style=\"font-weight:bold;border:2px solid #949090;padding:2%;\">ATTRIBUTE IDP_NAME</td><td style=\"font-weight:bold;padding:2%;border:2px solid #949090; word-wrap:break-word;\">ATTRIBUTE VALUE</td></tr>");
            for (String key : moSAMLResponse.getAttributes().keySet()) {
                htmlStart = htmlStart.append("<tr><td style=\"font-weight:bold;border:2px solid #949090;padding:2%;\">" + key + "</td><td style=\"padding:2%;border:2px solid #949090;word-wrap:break-word;\">");
                Object[] values = moSAMLResponse.getAttributes().get(key);
                htmlStart = htmlStart.append(StringUtils.join((Object[])values, (String)"<hr/>"));
                htmlStart = htmlStart.append("</td></tr>");
            }
            htmlStart = htmlStart.append("</table></div>");
            htmlStart = htmlStart.append("<div style=\"margin:3%;display:block;text-align:center;\"></div>");
            return htmlStart.toString();
        }
        StringBuilder htmlStart = new StringBuilder("<div style=\"font-family:Calibri;padding:0 3%;\">");
        htmlStart = htmlStart.append("<div style=\"color:#a94442;background-color:#f2dede;padding:15px;margin-bottom:20px;text-align:center;border:1px solid #E6B3B2;font-size:18pt;\">TEST FAILED</div>");
        htmlStart = htmlStart.append("<table style=\"border-collapse:collapse;border-spacing:0; display:table;width:100%;font-size:14pt;\"><tr style=\"padding-top:10px;padding-bottom:10px;\"><td style=\"font-weight:bold;padding:10px 5px 10px 5px;\">Error Code</td><td style=\"word-wrap:break-word;\">" + (Object)((Object)e.getErrorCode()) + "</td></tr><tr><td style=\"font-weight:bold;padding:10px 5px 10px 5px;\">Error Message</td><td style=\"word-wrap:break-word;\">" + e.getMessage() + "</td></tr><tr><td style=\"font-weight:bold;padding:10px 5px 10px 5px;\">Resolution</td><td style=\"word-wrap:break-word;\">" + e.getResolution() + "</tr></table></div>");
        return htmlStart.toString();
    }

    public static Response decodeResponse(String encodedResponse) throws ParserConfigurationException, SAXException, IOException, UnmarshallingException {
        LOGGER.debug("Decoding Response..");
        String xml = new String(org.opensaml.xml.util.Base64.decode((String)encodedResponse), StandardCharsets.UTF_8);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        documentBuilderFactory.setExpandEntityReferences(false);
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder docBuilder = documentBuilderFactory.newDocumentBuilder();
        ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8));
        Document document = docBuilder.parse(is);
        Element element = document.getDocumentElement();
        UnmarshallerFactory unmarshallerFactory = Configuration.getUnmarshallerFactory();
        Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(element);
        XMLObject xmlObj = unmarshaller.unmarshall(element);
        return (Response)xmlObj;
    }

    public static Boolean verifyCertificate(SignableXMLObject response, String certificate) throws ValidationException, CertificateException, InvalidKeySpecException, NoSuchAlgorithmException {
        LOGGER.debug("Varifing Certificate");
        if (response.isSigned()) {
            SAMLSignatureProfileValidator profileValidator = new SAMLSignatureProfileValidator();
            profileValidator.validate(response.getSignature());
            Credential verificationCredential = MoSAMLUtils.getCredential(certificate, "");
            SignatureValidator sigValidator = new SignatureValidator(verificationCredential);
            sigValidator.validate(response.getSignature());
            return Boolean.TRUE;
        }
        if (response instanceof Response) {
            LOGGER.error("Response not Signed");
            throw new MoSAMLException(MoSAMLException.SAMLErrorCode.RESPONSE_NOT_SIGNED);
        }
        LOGGER.error("Assertion not Signed");
        throw new MoSAMLException(MoSAMLException.SAMLErrorCode.ASSERTION_NOT_SIGNED);
    }

    private static Status buildStatus(String statusCodeValue) {
        LOGGER.debug("Building Status");
        StatusCode statusCode = new StatusCodeBuilder().buildObject("urn:oasis:names:tc:SAML:2.0:protocol", "StatusCode", NAMESPACE_PREFIX);
        statusCode.setValue(statusCodeValue);
        Status status = new StatusBuilder().buildObject("urn:oasis:names:tc:SAML:2.0:protocol", "Status", NAMESPACE_PREFIX);
        status.setStatusCode(statusCode);
        return status;
    }

    public static String getIdAsJwt(MoSAMLResponse samlResponse, String id, String issuer, long ttlMillis, String key) {
        HashMap<String, String> idMap = new HashMap<String, String>();
        idMap.put("NameID", samlResponse.getNameId());
        idMap.put("SessionIndex", samlResponse.getSessionIndex());
        Gson gson = new Gson();
        String idJson = gson.toJson(idMap);
        return MoSAMLUtils.generateJWT(id, issuer, idJson, ttlMillis, key);
    }

    public static String getAttributesAsJwt(MoSAMLResponse samlResponse, String id, String issuer, long ttlMillis, String key) {
        HashMap<String, String[]> attributeMap = new HashMap<String, String[]>();
        for (String attrKey : samlResponse.getAttributes().keySet()) {
            String[] values = samlResponse.getAttributes().get(attrKey);
            attributeMap.put(attrKey, values);
        }
        Gson gson = new Gson();
        String attrJson = gson.toJson(attributeMap);
        return MoSAMLUtils.generateJWT(id, issuer, attrJson, ttlMillis, key);
    }

    public static String generateJWT(String id, String issuer, String subject, long ttlMillis, String key) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        long nowMillis = System.currentTimeMillis();
        Date now = new Date(nowMillis);
        String base64EncodedKey = key;
        JwtBuilder builder = Jwts.builder().setId(id).setIssuer(issuer).setIssuedAt(now).setSubject(subject).signWith(signatureAlgorithm, base64EncodedKey);
        if (ttlMillis >= 0L) {
            long expMillis = nowMillis + ttlMillis;
            Date exp = new Date(expMillis);
            builder.setExpiration(exp);
        }
        return builder.compact();
    }

    public static String parseJWT(String jwt) {
        String base64SecretBytes = "1DC5BC952855A614F30376298E74ADBDFEB1722745D4365465D652AB1EBBAD46";
        Claims claims = (Claims)Jwts.parser().setSigningKey(base64SecretBytes).parseClaimsJws(jwt).getBody();
        return claims.getSubject();
    }

    public static void testDisplay(HttpServletResponse response, HttpServletRequest request) {
        try {
            String string = request.getParameter("output");
            response.setCharacterEncoding("iso-8859-1");
            response.setContentType("text/html");
            String decoded = MoSAMLUtils.decoder(string);
            response.getOutputStream().write(decoded.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static String decoder(String data) {
        try {
            data = data.replaceAll("%(?![0-9a-fA-F]{2})", "%25");
            data = data.replaceAll("\\+", "%2B");
            data = URLDecoder.decode(data, StandardCharsets.UTF_8.toString());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
        return data;
    }

    public static String sendPostRequest(String url, String data, String contentType, HashMap<String, String> headers) {
        try {
            LOGGER.debug("MoHttpUtils sendPostRequest Sending POST request to " + url + " with payload " + data);
            CloseableHttpClient httpClient = MoSAMLUtils.getHttpClient();
            HttpPost postRequest = new HttpPost(url);
            if (headers != null) {
                Iterator<Map.Entry<String, String>> iterator = headers.entrySet().iterator();
                if (!headers.isEmpty()) {
                    while (iterator.hasNext()) {
                        Map.Entry<String, String> pairs = iterator.next();
                        postRequest.setHeader(pairs.getKey().toString(), pairs.getValue().toString());
                    }
                }
            }
            StringEntity input = new StringEntity(data);
            input.setContentType(contentType);
            postRequest.setEntity((HttpEntity)input);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)postRequest);
            LOGGER.debug("Response for HTTP Request: " + response.toString() + " and Status Code: " + response.getStatusLine().getStatusCode());
            if (response.getEntity() != null) {
                String output;
                LOGGER.debug("Response Entity found. Reading Response payload.");
                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                String status = "";
                while ((output = br.readLine()) != null) {
                    status = status + output;
                }
                LOGGER.debug("Response payload: " + status);
                httpClient.close();
                return status;
            }
            LOGGER.debug("Response Entity NOT found. Returning EMPTY string.");
            httpClient.close();
            return "";
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            e.printStackTrace();
            return "";
        }
    }

    private static CloseableHttpClient getHttpClient() throws KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        HttpClientBuilder builder = HttpClientBuilder.create();
        SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

            public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                return true;
            }
        }).build();
        SSLConnectionSocketFactory sslConnectionFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        builder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionFactory);
        Registry registry = RegistryBuilder.create().register("https", (Object)sslConnectionFactory).register("http", (Object)PlainConnectionSocketFactory.INSTANCE).build();
        BasicHttpClientConnectionManager ccm = new BasicHttpClientConnectionManager((Lookup)registry);
        builder.setConnectionManager((HttpClientConnectionManager)ccm);
        SystemDefaultRoutePlanner routePlanner = new SystemDefaultRoutePlanner(ProxySelector.getDefault());
        CloseableHttpClient httpclient = HttpClients.custom().setRoutePlanner((HttpRoutePlanner)routePlanner).setConnectionManager((HttpClientConnectionManager)ccm).build();
        return httpclient;
    }
}

