/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.saml;

import com.miniorange.app.classes.MoSAMLException;
import com.miniorange.app.classes.MoSAMLResponse;
import com.miniorange.app.helpers.MoSAMLFeedback;
import com.miniorange.app.helpers.MoSAMLManager;
import com.miniorange.app.helpers.MoSAMLSPMeta;
import com.miniorange.app.helpers.MoSAMLSettings;
import com.miniorange.app.helpers.MoSAMLUtils;
import com.miniorange.saml.MiniorangeSamlProperties;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.server.ServerSide;
import org.sonar.api.server.authentication.Display;
import org.sonar.api.server.authentication.OAuth2IdentityProvider;
import org.sonar.api.server.authentication.UserIdentity;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

@ServerSide
public class MiniorangeAuthProvider
implements OAuth2IdentityProvider {
    private static final String RELAYSTATE = "RelayState";
    private static int userCount = 1;
    private final MoSAMLSettings settings = new MoSAMLSettings();
    private MoSAMLManager manager = new MoSAMLManager();
    private static Logger LOGGER = Loggers.get(MiniorangeAuthProvider.class);
    private static MiniorangeSamlProperties property;

    public MiniorangeAuthProvider(MiniorangeSamlProperties property) {
        MiniorangeAuthProvider.property = property;
    }

    public String getKey() {
        return "miniorangesamlplugin";
    }

    public String getName() {
        return MiniorangeSamlProperties.getConfiguration().get("mo.saml.idp_name").orElse("SAML IDP");
    }

    public Display getDisplay() {
        return Display.builder().setIconPath("/static/miniorangesamlplugin/icon.png").setBackgroundColor("#444444").build();
    }

    public boolean isEnabled() {
        return this.settings.isEnabled();
    }

    public boolean allowsUsersToSignUp() {
        if (userCount > 10) {
            LOGGER.debug("User creation count exceed. Please upgrade to premium version for unlimited user creation.");
            return false;
        }
        ++userCount;
        return this.settings.allowSignUp();
    }

    public void init(OAuth2IdentityProvider.InitContext context) {
        LOGGER.debug("Init method called");
        String relayState = this.settings.getSpBaseUrl();
        LOGGER.debug("RelayState Parameter : " + context.getRequest().getParameter(RELAYSTATE));
        if (!this.settings.isSPBaseURLSet() && !context.getRequest().getParameterMap().containsKey("returnWith")) {
            LOGGER.debug("Sp base url is not set");
            relayState = context.getRequest().getParameter(RELAYSTATE);
            if (StringUtils.isBlank((String)relayState)) {
                relayState = "";
            }
            MoSAMLSPMeta.initializeMetadata(context.getResponse(), context.getRequest(), relayState);
            return;
        }
        if (context.getRequest().getParameterMap().containsKey(RELAYSTATE)) {
            LOGGER.debug("Relay state present : " + context.getRequest().getParameter(RELAYSTATE));
            if (context.getRequest().getParameter(RELAYSTATE).equals("init_spmeta")) {
                LOGGER.debug("Generating SP Metadata...");
                MoSAMLSPMeta.generateSPMeta(context.getResponse(), context.getRequest());
                return;
            }
            if (context.getRequest().getParameter(RELAYSTATE).equals("test_config")) {
                LOGGER.debug("Setting test relay state...");
                relayState = context.getRequest().getParameter(RELAYSTATE);
            }
            if (context.getRequest().getParameter(RELAYSTATE).equals("show_result")) {
                LOGGER.debug("Showing Test configuration result");
                MoSAMLUtils.testDisplay(context.getResponse(), context.getRequest());
                return;
            }
            if (context.getRequest().getParameter(RELAYSTATE).equals("show_metadata")) {
                LOGGER.debug("Showing SP Metadata...");
                MoSAMLSPMeta.showMetadata(context.getResponse(), context.getRequest());
                return;
            }
            if (context.getRequest().getParameter(RELAYSTATE).equals("download_metadata")) {
                LOGGER.debug("Downloading Metadata File...");
                MoSAMLSPMeta.downloadMetadata(context.getResponse(), context.getRequest());
                return;
            }
            if (context.getRequest().getParameter(RELAYSTATE).equals("download_certificate")) {
                LOGGER.debug("Downloading SP Certificate...");
                MoSAMLSPMeta.downloadCertificate(context.getResponse());
                return;
            }
            if (context.getRequest().getParameter(RELAYSTATE).equals("feedback")) {
                LOGGER.info("Sending Feedback...");
                new MoSAMLFeedback(this.settings).sendFeedback(context.getRequest(), context.getResponse());
                return;
            }
        }
        this.manager.createAuthnRequestAndRedirect(context.getResponse(), context.getRequest(), relayState, this.settings);
    }

    public void callback(OAuth2IdentityProvider.CallbackContext callbackContext) {
        MoSAMLManager manager = new MoSAMLManager();
        MoSAMLException exception = null;
        MoSAMLResponse samlResponse = null;
        LOGGER.debug("Reading response...");
        samlResponse = manager.readSAMLResponse(callbackContext.getRequest(), this.settings);
        String relaystate = callbackContext.getRequest().getParameter(RELAYSTATE);
        if (callbackContext.getRequest().getParameterMap().containsKey(RELAYSTATE) && Objects.equals(callbackContext.getRequest().getParameter(RELAYSTATE), "test_config")) {
            LOGGER.debug("Test relay state found. Processing output...");
            try {
                String output = MoSAMLUtils.showTestConfigurationResult(samlResponse, exception);
                String baseUrl = this.settings.getSpBaseUrl();
                callbackContext.getResponse().sendRedirect(baseUrl + "/sessions/init/miniorangesamlplugin?RelayState=show_result&output=" + URLEncoder.encode(output, "UTF-8"));
                return;
            }
            catch (IOException e) {
                LOGGER.debug(e.getMessage());
            }
        }
        Map<String, String[]> attributes = samlResponse.getAttributes();
        UserIdentity.Builder userIdentityBuilder = UserIdentity.builder().setLogin(this.getValue(attributes, this.settings.getLoginAttr())).setProviderLogin(this.getValue(attributes, this.settings.getLoginAttr())).setName(this.getValue(attributes, this.settings.getNameAttr()));
        callbackContext.authenticate(userIdentityBuilder.build());
        callbackContext.redirectToRequestedPage();
    }

    String getValue(Map<String, String[]> attributes, String key) {
        String[] keyArray = new String[10];
        if (attributes.containsKey(key)) {
            keyArray = attributes.get(key);
        }
        return keyArray[0];
    }
}

