/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.saml;

import java.util.Arrays;
import java.util.List;
import org.sonar.api.Plugin;
import org.sonar.api.PropertyType;
import org.sonar.api.config.Configuration;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.api.server.ServerSide;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

@ServerSide
public class MiniorangeSamlProperties {
    private static Configuration config;
    static Logger LOGGER;

    public MiniorangeSamlProperties(Configuration configuration) {
        config = configuration;
    }

    public static Configuration getConfiguration() {
        return config;
    }

    public static List<PropertyDefinition> definitions(Plugin.Context context) {
        return Arrays.asList(PropertyDefinition.builder((String)"mo.saml.enable").name("Enable SAML Login").description("Enable SAML SSO Authentication for Users. This Value will be ignored if below fields of IDP metadata are empty.").category("miniOrange SAML").subCategory("1) miniOrange SAML Authentication (For SP details go to >>Administration >>Configuration >>miniOrange_SAML_Support).").type(PropertyType.BOOLEAN).defaultValue(String.valueOf(false)).index(1).build(), PropertyDefinition.builder((String)"mo.saml.sign_up").name("Allow Sign Up").description("Allow users to sign up if their account doesn't already exist, using SSO Authentication with your IDP").category("miniOrange SAML").subCategory("1) miniOrange SAML Authentication (For SP details go to >>Administration >>Configuration >>miniOrange_SAML_Support).").type(PropertyType.BOOLEAN).defaultValue(String.valueOf(true)).index(2).build(), PropertyDefinition.builder((String)"mo.saml.idp_name").name("IDP Name").description("Name of your IDP.").category("miniOrange SAML").subCategory("2) Setup Identity Provider").type(PropertyType.STRING).defaultValue("SAML IDP").index(1).build(), PropertyDefinition.builder((String)"mo.saml.idp_entity_id").name("IDP Entity ID").description(MiniorangeSamlProperties.required("Issuer ID provided by the IDP")).category("miniOrange SAML").subCategory("2) Setup Identity Provider").type(PropertyType.STRING).index(2).build(), PropertyDefinition.builder((String)"mo.saml.idp_login_url").name("Login URL").description(MiniorangeSamlProperties.required("SAML Login URL of the IDP where the SAML request is sent.")).category("miniOrange SAML").subCategory("2) Setup Identity Provider").type(PropertyType.STRING).index(3).build(), PropertyDefinition.builder((String)"mo.saml.bind_type").name("SAML Login Binding Type").description("Method used for sending SAML Login request.").category("miniOrange SAML").subCategory("2) Setup Identity Provider").type(PropertyType.SINGLE_SELECT_LIST).options("HttpRedirect", new String[]{"HttpPost"}).defaultValue("HttpRedirect").index(4).build(), PropertyDefinition.builder((String)"mo.saml.idp_x509").name("X.509 Certificate").description(MiniorangeSamlProperties.required("x509 Certificate provided by IDP to verify response from it.")).category("miniOrange SAML").subCategory("2) Setup Identity Provider").type(PropertyType.TEXT).index(4).build(), PropertyDefinition.builder((String)"mo.saml.login_attr").name("Login Attribute").description(MiniorangeSamlProperties.required("Name of attribute in SAML response to be used as login credential.")).category("miniOrange SAML").subCategory("3) User Profile Mapping").type(PropertyType.STRING).defaultValue("NameID").index(1).build(), PropertyDefinition.builder((String)"mo.saml.name_attr").name("Name Attribute").description(MiniorangeSamlProperties.required("Name of attribute in SAML response to be used as name credential.")).category("miniOrange SAML").subCategory("3) User Profile Mapping").type(PropertyType.STRING).defaultValue("NameID").index(2).build(), PropertyDefinition.builder((String)"mo.saml.sonarqube_version").name("SonarQube Version").description("For internal use only").category("miniOrange SAML").subCategory("3) User Profile Mapping").type(PropertyType.BOOLEAN).hidden().defaultValue(MiniorangeSamlProperties.getSonarQubeVersion(context)).index(3).build());
    }

    static String required(String input) {
        input = input.concat("<span style=\"color:red\">*</span>");
        return input;
    }

    private static String getSonarQubeVersion(Plugin.Context context) {
        String version = context.getSonarQubeVersion().toString();
        return version;
    }

    static {
        LOGGER = Loggers.get(MiniorangeSamlProperties.class);
    }
}

